package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.dao.SysWorkFlowInstanceExtDao;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.struts2.ServletActionContext;

import java.util.*;

public class CreateCheckAction extends ActionSupport{
	private SysWorkFlowInstanceExtDao workFlowInstanceExtDao;
    /** 工作流实例名 */
	private String instanceName;
    /** 工作流定义Id */
	private String wdid;

	public String execute() throws Exception {
		return Action.NONE;
	}

	public String checkHasWorkflow() throws Exception {
		String msg = "";
		try {
			if (StringUtils.isNotBlank(wdid) && StringUtils.isNotBlank(instanceName)){
				HashMap map = new HashMap();
				map.put("WORKFLOW_DEFINITION_ID",wdid);
				map.put("WORKFLOW_INSTANCE_NAME",instanceName);
				List<PfWorkFlowInstanceVo> list = workFlowInstanceExtDao.getWorkFlowsInstanceByDefine(map);
				if (list != null && list.size() > 0){
					msg = String.valueOf(list.size());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		ServletActionContext.getResponse().getWriter().print(msg);
		return Action.NONE;
	}

	public SysWorkFlowInstanceExtDao getWorkFlowInstanceExtDao() {
		return workFlowInstanceExtDao;
	}

	public void setWorkFlowInstanceExtDao(SysWorkFlowInstanceExtDao workFlowInstanceExtDao) {
		this.workFlowInstanceExtDao = workFlowInstanceExtDao;
	}

	public String getInstanceName() {
		return instanceName;
	}

	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	public String getWdid() {
		return wdid;
	}

	public void setWdid(String wdid) {
		this.wdid = wdid;
	}
}
