package com.gtis.web.action;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.config.AppConfig;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.util.CalendarUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.*;

/**
 * User: JIFF
 * Date: 2014/10/15
 */
public class CalendarAction {
    SysCalendarService calendarService;
    SysTaskService taskService;
    SysWorkFlowInstanceService workFlowInstanceService;
    /** 分页 */
    private String pageInfo;

    private String overTime;

    public String getPageInfo() {
        return pageInfo;
    }

    public String getOverTime() {
        return overTime;
    }

    public void setOverTime(String overTime) {
        this.overTime = overTime;
    }

    public SysCalendarService getCalendarService() {
        return calendarService;
    }

    public void setCalendarService(SysCalendarService calendarService) {
        this.calendarService = calendarService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setWorkFlowInstanceService(SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public String execute() throws Exception {
        SplitParam splitParam=new SplitParamImpl();
        splitParam.setQueryString("getProjectList");
        pageInfo=ByteObjectAccess.objectToString(splitParam);
        return Action.SUCCESS;
    }

    public String refresh() throws Exception {
        calendarService.reloadWorkdaysAndHolidays();
        return Action.NONE;
    }

    public String calWorkDay() throws Exception {
        String[] wiids= ServletActionContext.getRequest().getParameterValues("wiid");
        if (wiids!=null && wiids.length>0){
            String wiid=wiids[0];
            PfWorkFlowInstanceVo workFlowInstanceVo= workFlowInstanceService.getWorkflowInstance(wiid);
            if (workFlowInstanceVo!=null) {
                //////
                if (workFlowInstanceVo.getOverTime() == null) {
                    Date overTime = calendarService.getOverTime(workFlowInstanceVo.getCreateTime(), workFlowInstanceVo.getTimeLimit());
                    workFlowInstanceService.updateWorkFlowIntanceOverTime(workFlowInstanceVo.getWorkflowIntanceId(), overTime);
                }
                List<PfActivityVo> activityVoList = taskService.getWorkFlowInstanceAllActivityList(workFlowInstanceVo.getWorkflowIntanceId());
                for (PfActivityVo activityVo : activityVoList) {
                    Date overTime2 = calendarService.getOverTime(activityVo.getBeginTime(), activityVo.getTimeLimit());
                    List<PfTaskVo> taskVos = taskService.getTaskListByActivity(activityVo.getActivityId());
                    for (PfTaskVo taskVo : taskVos) {
                        if (taskVo.getOverTime() == null)
                            taskService.updateTaskOverTime(taskVo.getTaskId(), overTime2);
                    }
                    List<PfTaskVo> taskHisVos = taskService.getHistoryTaskListByActivity(activityVo.getActivityId());
                    for (PfTaskVo taskVo : taskHisVos) {
                        if (taskVo.getOverTime() == null)
                            taskService.updateTaskHistoryOverTime(taskVo.getTaskId(), overTime2);
                    }
                }
            }
        }
        return Action.NONE;
    }

    public String calLeftTime(){
        String result = "";
        if(StringUtils.isNotBlank(overTime)){
            Date overDate = CommonUtil.formateDateToStr(overTime);
            result = String.valueOf(calendarService.getTimeLeft(overDate));
        }
        Struts2Utils.renderJson(result);
        return Action.NONE;
    }

    /**
     * 根据前台传递的批量任务id、理论超时时间来计算剩余多少工作日
     * 返回一个map，key为任务id，value为当前任务的剩余时间、上节点的转发人员
     * @return
     */
    public String calMoreLeftTime(){
        HashMap taskMap = new HashMap();
        if(StringUtils.isNotBlank(overTime)){
            List<HashMap> mapList = JSON.parseArray(overTime,HashMap.class);
            if (mapList != null && mapList.size() > 0){
                for (int i = 0; i < mapList.size(); i++) {
                    HashMap map = mapList.get(i);
                    String tmpTaskId= MapUtils.getString(map,"TASKID");

                    map.put("TIME_LEFT",initTimeLeft(MapUtils.getString(map,"TASK_OVER_TIME")));
                    map.put("FORWARDER",initSendUsers(tmpTaskId));
                    taskMap.put(tmpTaskId,map);
                }
            }
        }
        Struts2Utils.renderJson(JSON.toJSONString(taskMap));
        return Action.NONE;
    }

    /**
     * 根据前台传递的批量任务id，计算上节点的转发人员
     * 返回一个map，key为任务id，value为当前任务上节点的转发人员
     * @return
     */
    public String calMoreSendUsers(){
        HashMap taskMap = new HashMap();
        if(StringUtils.isNotBlank(overTime)){
            List<HashMap> mapList = JSON.parseArray(overTime,HashMap.class);
            if (mapList != null && mapList.size() > 0){
                for (int i = 0; i < mapList.size(); i++) {
                    HashMap map = mapList.get(i);
                    String tmpTaskId= MapUtils.getString(map,"TASKID");
                    map.put("FORWARDER",initSendUsers(tmpTaskId));
                    taskMap.put(tmpTaskId,map);
                }
            }
        }
        Struts2Utils.renderJson(JSON.toJSONString(taskMap));
        return Action.NONE;
    }
    /**
     * 根据前台传递的批量项目id，计算项目的当前节点状态和剩余时间
     * 返回一个map，key为任务id，value为当前项目的描述信息
     * @return
     */
    public String getMoreActivityNames() throws Exception{
        HashMap taskMap = new HashMap();
        if(StringUtils.isNotBlank(overTime)){
            List<HashMap> mapList = JSON.parseArray(overTime,HashMap.class);
            if (mapList != null && mapList.size() > 0){
                for (int i = 0; i < mapList.size(); i++) {
                    HashMap map = mapList.get(i);
                    String wiid= MapUtils.getString(map,"WORKFLOW_INSTANCE_ID");
                    map.put("ACTIVITY_NAMES",initProjectActivityNames(wiid));
                    taskMap.put(wiid,map);
                }
            }
        }
        Struts2Utils.renderJson(JSON.toJSONString(taskMap));
        return Action.NONE;
    }

    private int initTimeLeft(String taskOverTime){
        Date overDate = CommonUtil.formateDateToStr(taskOverTime);
        return calendarService.getTimeLeft(overDate);
    }

    private String initSendUsers(String tmpTaskId){
        StringBuffer userNameBuffer=new StringBuffer();
        PfTaskVo taskVo = taskService.getTask(tmpTaskId);
        if (taskVo==null){
            taskVo = taskService.getHistoryTask(tmpTaskId);
        }
        List<PfTaskVo> beforeTasks=taskService.getHistoryTaskByBefore(taskVo);
        if (beforeTasks!=null && beforeTasks.size()>0) {
            int size=0;
            for (PfTaskVo task:beforeTasks) {
                size++;
                if (size==2 && beforeTasks.size()>2) {
                    userNameBuffer.append(task.getUserVo().getUserName() + "等");
                }else{
                    userNameBuffer.append(task.getUserVo().getUserName() + " ");
                }
            }
        }else{
            userNameBuffer.append("");
        }
        return userNameBuffer.toString();
    }

    private String initProjectActivityNames(String wiid){
        StringBuffer userNameBuffer=new StringBuffer();
        if (StringUtils.isNotBlank(wiid)) {
            List<PfActivityVo> activityVoList= taskService.getWorkFlowInstanceActivityList(wiid);
            for (int i = 0; i < activityVoList.size(); i++) {
                if (i>0) {
                    userNameBuffer.append(";");
                }
                try {
                    PfActivityVo activityVo = activityVoList.get(i);
                    userNameBuffer.append(activityVo.getActivityName());
                    String projectShowTime= AppConfig.getProperty("projectlist.activityName.otherTime.show");
                    if(org.apache.commons.lang3.StringUtils.equals(projectShowTime,"true")) {
                        List<PfTaskVo> taskList = taskService.getTaskListByActivity(activityVo.getActivityId());
                        if (taskList != null && taskList.size() > 0) {
                            PfTaskVo taskVo = taskList.get(0);
                            if (taskVo.getOverTime().compareTo(CalendarUtil.getCurDate()) < 0) {
                                userNameBuffer.append("已超期");
                            } else {
                                long days = CalendarUtil.getDaysByTwoDate(CalendarUtil.getCurDate(), taskVo.getOverTime());
                                userNameBuffer.append("剩余" + days + "天");
                            }
                        }
                        if (i > 0) {
                            userNameBuffer.append("...");
                            break;
                        } else {
                            userNameBuffer.append("");
                        }
                    }
                }catch (Exception ex){}
            }
        }
        return userNameBuffer.toString();
    }
}
