
package com.gtis.web.action;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOpinionVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 */
public class AcceptpeopleAction {
	
	
	private List<PfOrganVo> lstOrgan;
    private List<PfRoleVo> lstRole;
	
	private SysUserService userService;
	private String organId;
    private String roleId;
    private List<Map> orgList;
    private List<Map> roleList;
	
	public String getOrganId() {
		return organId;
	}

	public void setOrganId(String organId) {
		this.organId = organId;
	}

	public String execute() throws Exception {
		return Action.SUCCESS;
	}

	public String getuser() throws Exception{
        List<PfUserVo> lstUsers = null;
        if(StringUtils.isNotBlank(organId))
            lstUsers= userService.getUserListByOragn(organId);
        if(StringUtils.isNotBlank(roleId))
            lstUsers = userService.getUserListByRole(roleId);

		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(lstUsers));
		return Action.NONE;
	}

    private void buidlOrganTree(List<PfOrganVo> organList,Map parentOrgMap,String parentId){
        for(PfOrganVo pfOrganVo:organList){
           if(StringUtils.isNotBlank(pfOrganVo.getSuperOrganId())&&parentId.equals(pfOrganVo.getSuperOrganId())){
               Map orgMap = new HashMap();
               orgMap.put("id",pfOrganVo.getOrganId());
               orgMap.put("text",pfOrganVo.getOrganName());
               orgMap.put("children",new ArrayList());
               orgMap.put("iconCls","icon-dept");
               ((ArrayList)parentOrgMap.get("children")).add(orgMap);
               buidlOrganTree(lstOrgan,orgMap,pfOrganVo.getOrganId());
               if(((ArrayList)orgMap.get("children")).size()>0)
                   orgMap.put("state","closed");
           }
        }
    }

    public String getOrganTree() throws Exception{
        orgList = new ArrayList<Map>();
        lstOrgan=userService.getOrganList();
        for(PfOrganVo pfOrganVo:lstOrgan){
            if(StringUtils.isBlank(pfOrganVo.getSuperOrganId())){
                Map orgMap = new HashMap();
                orgMap.put("id",pfOrganVo.getOrganId());
                orgMap.put("text",pfOrganVo.getOrganName());
                orgMap.put("children",new ArrayList());
                orgMap.put("iconCls","icon-dept");

                buidlOrganTree(lstOrgan,orgMap,pfOrganVo.getOrganId());
                if(((ArrayList)orgMap.get("children")).size()>0)
                    orgMap.put("state","closed");
                orgList.add(orgMap);
            }
        }
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(orgList));
        return Action.NONE;
    }


    public String getRoleTree() throws Exception{
        roleList = new ArrayList<Map>();
        lstRole=userService.getRoleList();
        for(PfRoleVo pfRoleVo:lstRole){
            Map orgMap = new HashMap();
            orgMap.put("id",pfRoleVo.getRoleId());
            orgMap.put("text",pfRoleVo.getRoleName());
            orgMap.put("children",new ArrayList());
            orgMap.put("iconCls","icon-role");
            roleList.add(orgMap);
        }
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(roleList));
        return Action.NONE;
    }
	
	public List<PfOrganVo> getLstOrgan() {
		return lstOrgan;
	}

	public void setLstOrgan(List<PfOrganVo> lstOrgan) {
		this.lstOrgan = lstOrgan;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
		
	}

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }
}