package com.gtis.web;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.context.HttpSessionContextIntegrationFilter;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.ui.session.HttpSessionApplicationEvent;
import org.springframework.security.ui.session.HttpSessionCreatedEvent;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.AttendanceService;
import com.gtis.plat.vo.UserInfo;

import javax.servlet.http.HttpSession;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-4-1
 */
public class SessionStorage implements ApplicationListener {

    private Map<String, HttpSession> sessions = Collections.synchronizedMap(new LinkedHashMap<String, HttpSession>());
    AttendanceService attendanceService;
    
    public Collection<HttpSession> getSessions() {
        return sessions.values();
    }
    
    public AttendanceService getAtten4danceService() {
		return attendanceService;
	}

	public void setAttendanceService(AttendanceService attendanceService) {
		this.attendanceService = attendanceService;
	}

	public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionApplicationEvent) {
            HttpSession session = ((HttpSessionApplicationEvent) event).getSession();
            if (event instanceof HttpSessionCreatedEvent) {
                sessions.put(session.getId(), session);
            } else {
            	//正常退出时打卡
            	if(SessionUtil.getCurrentUser()!=null){
            		if(StringUtils.isNotBlank(SessionUtil.getCurrentUser().getUsername())){
                        attendanceService.goOffWork(SessionUtil.getCurrentUser().getUsername());
                	}
            	//非正常退出时或session失效时打卡
            	}else{
            		SecurityContext sc = (SecurityContext) session.getAttribute(HttpSessionContextIntegrationFilter.SPRING_SECURITY_CONTEXT_KEY);
                    if (sc != null){
                    	UserInfo ui = (UserInfo) sc.getAuthentication().getPrincipal();
                    	attendanceService.goOffWork(ui.getUsername());
                    }
            	}
                sessions.remove(session.getId());
            }
        }
    }
}
