package com.gtis.web;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

import org.apache.commons.logging.LogFactory;


/**
 * <?xml version="1.0" encoding="gb2312"?> <CONFIG> <!-- type JBOSS/TOMCAT -->
 * <WEBAPPLICATIONTYPE type="TOMCAT"/> <!-- 平台WAR包名称 --> <WEBROOT
 * name="docroot"/> </CONFIG>
 */
public class ResourceFileLoader {
	private static final org.apache.commons.logging.Log log = LogFactory
    .getLog(ResourceFileLoader.class);
	private static ResourceFileLoader hInstance = null;
	private static String applicationType="";
	private static String webRootName="";
	private static String configFileName="";
	private synchronized static boolean init() {
		try {
			hInstance = new ResourceFileLoader();
			hInstance.loadFile();
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	public static String getPlatPath(){
		if (hInstance==null) init();
		URL url = hInstance.getClass().getResource("config.property");
		String path = url.getPath();
		path=path.replace("file:/", "");	
		try {
			path=java.net.URLDecoder.decode(path, "UTF-8");
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (path.lastIndexOf("WEB-INF")>0){  //查找当前包中有无配置文件 
			String busPath=path.substring(0,path.lastIndexOf("WEB-INF"));
			return busPath;	
		}else{
			if (applicationType.equals("TOMCAT")){
				String busPath="";
				if (path.indexOf("WEB-INF")>0){
					busPath=path.substring(0,path.lastIndexOf("lib")-1);
					busPath=busPath.substring(0,busPath.lastIndexOf("/"));
					
				}else{
					busPath=path.substring(0,path.lastIndexOf("lib")-1);
					busPath=busPath + "/";
				}
				String fileName=busPath +"webapps/" +  webRootName ;
				return fileName;
			}else{
				String busPath=path.substring(0,path.lastIndexOf("lib"));
				String fileName=busPath +"deploy/" +  webRootName ;
				return fileName;
			}
		}
		
	}
	public static String getResourceFileName(){
		if (hInstance==null) init();
		//if (!configFileName.equals("")) return configFileName;
		URL url = hInstance.getClass().getResource("config.property");
		String path = url.getPath();
		path=path.replace("file:/", "");	 //jar包中怎么有file:/
		String fileName="",busPath="";
		try {
			path=java.net.URLDecoder.decode(path, "UTF-8");
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		if (path.lastIndexOf("WEB-INF")>0){  //查找当前包中有无配置文件 
			busPath=path.substring(0,path.lastIndexOf("WEB-INF"));
			fileName=busPath+ "WEB-INF//applicationContext.xml";	
		}
		if (!webRootName.equals("") && !checkFile(fileName)){
			if (path.lastIndexOf(webRootName)>0)  //类在平台包内
				fileName=path.substring(0,path.lastIndexOf(webRootName) +webRootName.length()) + "/WEB-INF/applicationContext.xml";
			else if (path.lastIndexOf("WEB-INF")>0){  //类在平台包内 
				busPath=path.substring(0,path.lastIndexOf("WEB-INF")-1);
				fileName=busPath.substring(0,busPath.lastIndexOf("/")+1) + webRootName + "/WEB-INF/applicationContext.xml";	
			}else if (path.lastIndexOf("lib")>0) { //类在应用服务器包中  如  tomcat\server\lib 或 jboss\server\default\lib
				if (applicationType.equals("TOMCAT")){
					busPath=path.substring(0,path.lastIndexOf("lib")-1);
					busPath=busPath.substring(0,busPath.lastIndexOf("/"));
					fileName=busPath +"webapps/" +  webRootName + "/WEB-INF/applicationContext.xml";	
				}else{
					busPath=path.substring(0,path.lastIndexOf("lib"));
					fileName=busPath +"deploy/" +  webRootName + "/WEB-INF/applicationContext.xml";
				}
			}
		}
		if (!checkFile(fileName)){
			log.error("/************************"+fileName+"文件不存在请检查************************/");
		}else{
			configFileName=fileName;
		}
		return fileName;
	}
	
	private static boolean checkFile(String fileName){
		File file=new File(fileName);
		return file.exists();
	}
	
	public static String getApplicationType() {
		return applicationType;
	}

	public static void setApplicationType(String applicationType) {
		applicationType = applicationType;
	}
	
	public static String getWebRootName() {
		return webRootName;
	}

	public static void setWebRootName(String webRootName) {
		webRootName = webRootName;
	}

	private void loadFile() {
		try {
//			InputStream   is   =   this.getClass().getResourceAsStream("res_config.xml");
//			SAXReader sr = new SAXReader();
//			Document doc = sr.read(is);
//			
//			Node node = doc.selectSingleNode("//CONFIG/WEBAPPLICATIONTYPE");
//			if (node != null) {
//				applicationType = node.valueOf("@type").trim();
//	        }
//			node = doc.selectSingleNode("//CONFIG/WEBROOT");
//			if (node != null) {
//				webRootName = node.valueOf("@name").trim();
//	        }
			
			InputStream   is   =   this.getClass().getResourceAsStream("config.property");
			Properties p = new Properties();  
			p.load(is);           // 读入属性
			is.close();
			applicationType=p.getProperty("applicationtype");
			webRootName=p.getProperty("platwarname");
			
		} catch (Exception ex) {
			ex.printStackTrace();
			log.error("初试化Config.property失败！", ex);
		}
	}
	public static void main(String args[]) throws Exception {
		File file=new File("D:\\te st\\applicationContext.xml");
		
	}
}

