package com.gtis.web;

import com.gtis.common.util.RequestUtils;
import com.gtis.generic.util.SessionUtils;
import com.gtis.plat.vo.OnlineUser;
import org.springframework.web.filter.DelegatingFilterProxy;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * || req.getRequestURI().indexOf("/tag/") > 0
 */
public class CasWebFilter extends DelegatingFilterProxy {

    @Override
    public void doFilter(ServletRequest request, ServletResponse arg1,
                         FilterChain fc) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest) request;
        //req.setCharacterEncoding("GBK");
        if (req.getRequestURI().indexOf("/services/") > 0
                || req.getRequestURI().indexOf(".service") > 0
                || req.getRequestURI().indexOf("/formprint") > 0
                || req.getRequestURI().indexOf("/taskturn!trunXml.action") > 0
                || req.getRequestURI().indexOf("/taskturn!opinions.action") > 0) {
            fc.doFilter(request, arg1);
        } else {
            HttpServletRequest hsr = (HttpServletRequest) request;
            String ip = SessionUtils.get(hsr, OnlineUser.ONLINE_USER_IP);
            if (ip == null) {
                SessionUtils.put(hsr, OnlineUser.ONLINE_USER_IP, RequestUtils.getClientIP(hsr));
            }
            super.doFilter(request, arg1, fc);
        }
    }
}

