package com.gtis.util;

import java.util.*;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysStuffService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.spring.Container;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import com.gtis.common.util.*;
import com.gtis.plat.vo.*;

/**
 * @文件名 SjdUtil.java
 * @作者 卢向伟
 * @创建日期 2013-11-2
 * @创建时间 上午9:33:49 
 * @版本号 V 1.0
 */
public class SjdUtil {
	/**
	 * 获取收件单材料list
	 * @param vo
	 * @return
	 */
	public static List<SjdclVo> getSjdclListBySjdVo(SjdVo vo){
		List<SjdclVo> clList = new ArrayList<SjdclVo>();
		try {
			if (vo != null && vo.getSjd_cl() != null) {
				List<HashMap> tempList = (List<HashMap>)JSONUtil.deserialize(new String(vo.getSjd_cl()));
				for (int i = 0; i < tempList.size(); i++) {
					HashMap map = tempList.get(i);
					SjdclVo clVo = new SjdclVo();
					if (map.get("data_id") != null) {
						clVo.setData_id(map.get("data_id").toString());
					}
					if (map.get("bz") != null) {
						clVo.setBz(map.get("bz").toString());
					}
					
					if (map.get("jjr") != null) {
						clVo.setJjr(map.get("jjr").toString());
					}
					if (map.get("lxdh") != null) {
						clVo.setLxdh(map.get("lxdh").toString());
					}
					if (map.get("name") != null) {
						clVo.setName(map.get("name").toString());
					}
					
					if (map.get("xh") != null) {
						long value = (Long)map.get("xh");
						clVo.setXh((int)value);
					}
					if (map.get("node_id") != null) {
						long value = (Long)map.get("node_id");
						clVo.setNode_id((int)value);
					}
					if (map.get("num") != null) {
						long value = (Long)map.get("num");
						clVo.setNum((int)value);
					}
					if (map.get("ysnum") != null) {
						long value = (Long)map.get("ysnum");
						clVo.setYsnum((int)value);
					}else {
						clVo.setYsnum(clVo.getNum());
					}
					if (map.get("dbnum") != null) {
						long value = (Long)map.get("dbnum");
						clVo.setDbnum((int)value);
					}else {
						if (clVo.getNum() != null && clVo.getYsnum() != null && clVo.getNum() >= clVo.getYsnum()) {
							clVo.setDbnum(clVo.getNum() - clVo.getYsnum());
						}
					}
					
					if (map.get("proid") != null) {
						clVo.setProid(map.get("proid").toString());
					}
					if (map.get("sj_date") != null) {
						clVo.setSj_date(CommonUtil.formateDateToStr(map.get("sj_date").toString()));
					}
					if (map.get("sjdid") != null) {
						clVo.setSjdid(map.get("sjdid").toString());
					}
					if (map.get("sjr") != null) {
						clVo.setSjr(map.get("sjr").toString());
					}
					if (map.get("type") != null) {
						clVo.setType(map.get("type").toString());
					}
					if (map.get("user_id") != null) {
						clVo.setUser_id(map.get("user_id").toString());
					}
					clList.add(clVo);
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return clList;
	}

	/**
	 * 获得工作流定义中的附件类型(初始化文件中心附件文件夹)
	 * @param nodeService
	 * @param stuffService
	 * @param workflowInstanceId
	 * @param fileCenterNodeId
	 */
	public static void initWorkflowFileCenter(NodeService nodeService, SysStuffService stuffService,String workflowInstanceId,int fileCenterNodeId){

		if (StringUtils.isNotBlank(workflowInstanceId)){
			SysWorkFlowDefineService workFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineServiceImpl");
			SysWorkFlowInstanceService workFlowInstanceService = (SysWorkFlowInstanceService) Container.getBean("SysWorkFlowInstanceServiceImpl");
			PfWorkFlowInstanceVo workFlowInstanceVo = workFlowInstanceService.getWorkflowInstance(workflowInstanceId);
			if (workFlowInstanceVo != null){
				ServletActionContext.getRequest().setAttribute("workflowState",workFlowInstanceVo.getWorkflowState());
				PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
				if (workFlowDefineVo != null){
					List<Node> nodeChiles = nodeService.getChildNodes(fileCenterNodeId);
					if (nodeChiles == null || nodeChiles.size() <= 0){
						HashMap map = new HashMap();
						map.put("WORKFLOW_DEFINITION_ID",workFlowDefineVo.getWorkflowDefinitionId());
						//获得工作流定义中的附件类型
						List<HashMap<String,String>> configMaps = stuffService.getFileByStuffIdProId(map);
						if (configMaps != null && configMaps.size() > 0){
							LinkedHashMap<String,StuffConfigVo> stuffTreeMap = new LinkedHashMap<String, StuffConfigVo>();
							for (int i = 0; i < configMaps.size(); i++) {
								StuffConfigVo stuff = new StuffConfigVo();
								HashMap<String,String> configMap = configMaps.get(i);

								stuff.setStuffId(MapUtils.getString(configMap,"stuffConfigId"));
								stuff.setProId(MapUtils.getString(configMap,"stuffConfigProId"));
								stuff.setStuffName(MapUtils.getString(configMap,"stuffConfigName"));
								stuffTreeMap.put(stuff.getStuffId(),stuff);
							}

							StuffConfigVo root = new StuffConfigVo();
							root.setStuffId("treeroot");
							root.setStuffName("根节点");
							root.setStuffXh(fileCenterNodeId);
							for (StuffConfigVo tree : stuffTreeMap.values()) {
								if (tree.getProId() != null) {
									StuffConfigVo ztree = stuffTreeMap.get(tree.getProId());
									if (ztree != null) {
										ztree.addChild(tree);
									}else {
										tree.setProId("treeroot");
										root.addChild(tree);
									}
								}else {
									tree.setProId("treeroot");
									root.addChild(tree);
								}
							}

							if (root.getChildren() != null && root.getChildren().size() > 0){
								for (int i = 0; i < root.getChildren().size(); i++) {
									createFileTree(root,nodeService);
								}
							}
						}
					}
				}
			}
		}
	}

	public static void createFileTree(StuffConfigVo parent,NodeService nodeService){
		if (parent.getChildren() != null && parent.getChildren().size() > 0){
			for (int i = 0; i < parent.getChildren().size(); i++) {
				StuffConfigVo tree = parent.getChildren().get(i);
				Node stuffNode = nodeService.getNode(parent.getStuffXh(),tree.getStuffName(),true);
				//用xh字段临时代替文件中心节点id，用于下面获取父节点id的调用
				tree.setStuffXh(stuffNode.getId());
				createFileTree(tree,nodeService);
				parent.getChildren().set(i,tree);
			}
		}
	}
}
