/*
 * Copyright (c) 2014. Lorem ipsum dolor sit amet, consectetur adipiscing elit.
 * Morbi non lorem porttitor neque feugiat blandit. Ut vitae ipsum eget quam lacinia accumsan.
 * Etiam sed turpis ac ipsum condimentum fringilla. Maecenas magna.
 * Proin dapibus sapien vel ante. Aliquam erat volutpat. Pellentesque sagittis ligula eget metus.
 * Vestibulum commodo. Ut rhoncus gravida arcu.
 */

package com.gtis.plat.wf.count;

import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.CountProvider;
import com.gtis.spring.Container;

/**
 * 本地办件数量
 * Created by shenjian on 2014-06-08.
 */
public class TaskSiteCountImpl implements CountProvider {

    String name;

    /**
     * 返回某个业务的单位数量
     *
     * @return 数量
     */
    @Override
    public int getCount() {
        SysWorkFlowInstanceDao workFlowInstanceDao = (SysWorkFlowInstanceDao) Container.getBean("SysWorkFlowInstanceDao");
        Object count= workFlowInstanceDao.getOffSiteWorkFlowInstanceCount(false);
        if (count!=null)
            return Integer.parseInt(String.valueOf(count));
        else
            return 0;
    }

    /**
     * 返回业务名，需要和前台的菜单名对应
     *
     * @return 业务名
     */
    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
