/*
 * Copyright (c) 2014. Lorem ipsum dolor sit amet, consectetur adipiscing elit.
 * Morbi non lorem porttitor neque feugiat blandit. Ut vitae ipsum eget quam lacinia accumsan.
 * Etiam sed turpis ac ipsum condimentum fringilla. Maecenas magna.
 * Proin dapibus sapien vel ante. Aliquam erat volutpat. Pellentesque sagittis ligula eget metus.
 * Vestibulum commodo. Ut rhoncus gravida arcu.
 */

package com.gtis.plat.wf.count;

import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.service.CountProvider;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;

import java.util.HashMap;

/**
 * 办理业务种类数量
 * Created by shenjian on 2014-06-08.
 */
public class TaskCatetoryCountImpl implements CountProvider {
    String name;
    /**
     * 返回某个用户所能办理的业务数量
     *
     * @return 数量
     */
    @Override
    public int getCount() {
        SysWorkFlowDefineDao workFlowDefineDao = (SysWorkFlowDefineDao) Container.getBean("SysWorkFlowDefineDao");
        HashMap<String,String> map=new HashMap<String,String>();
        Object count = workFlowDefineDao.getWorkFlowDefineCountByRole(SessionUtil.getCurrentUser().getRoleIds(),null,null);
        if (count!=null)
            return Integer.parseInt(String.valueOf(count));
        else
            return 0;
    }

    /**
     * 返回业务名，需要和前台的菜单名对应
     *
     * @return 业务名
     */
    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
