package com.gtis.plat.wf.bean;


import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowPostService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.PfWorkFlowPostVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowInfo;
import org.apache.commons.lang.StringUtils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class unLockWorkFlowInstanceBean extends WorkFlowBeanAbstract {
    SysWorkFlowPostService workFlowPostService;
    SysCalendarService calendarService;

    public void setWorkFlowPostService(SysWorkFlowPostService workFlowPostService) {
        this.workFlowPostService = workFlowPostService;
    }

    public void setCalendarService(SysCalendarService calendarService) {
        this.calendarService = calendarService;
    }

    /**
	 * 解除挂起工作流
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		String workflowIntanceId = infoObj.getWorkFlowIntanceVo()
				.getWorkflowIntanceId();
		PfWorkFlowInstanceVo intanceVo = super.getWorFlowInstanceService()
				.getWorkflowInstance(workflowIntanceId);
		intanceVo.setWorkflowState(WorkFlowEnum.WORKFLOW_START);
		super.getWorFlowInstanceService()
				.updateWorkFlowIntanceStadus(intanceVo);

        //操作挂起表
        double hours=0;
        String taskId=null;
        List<PfWorkFlowPostVo> workFlowPosts= workFlowPostService.getPostByInstance(workflowIntanceId);
        for(PfWorkFlowPostVo postVo:workFlowPosts){
            if (postVo.getUnPostDate()==null){
                postVo.setUnPostDate(Calendar.getInstance().getTime());
                workFlowPostService.updatePost(postVo);
                taskId=postVo.getTaskId();
                hours=hours + calendarService.getWorkDayHours(postVo.getPostDate(),postVo.getUnPostDate());
            }

        }

        Date overTime= calendarService.getOverTime(intanceVo.getCreateTime(),intanceVo.getTimeLimit());
        if (hours>0)
            overTime=calendarService.getOverTime(overTime,String.valueOf(hours) + "h");
        //重新计算超期时间-实例
        super.getWorFlowInstanceService().updateWorkFlowIntanceOverTime(workflowIntanceId,overTime);
        //任务的超期时间
        if (StringUtils.isNotBlank(taskId)) {
            PfTaskVo taskVo=super.getTaskService().getTask(taskId);
            hours = 0;
            List<PfWorkFlowPostVo> workFlowTaskPosts = workFlowPostService.getPostByTask(taskId);
            if (workFlowTaskPosts!=null&&workFlowTaskPosts.size()>0) {
                if (workFlowTaskPosts.get(0).getUnPostDate() != null) {
                    hours = hours + calendarService.getWorkDayHours(workFlowTaskPosts.get(0).getPostDate(), workFlowTaskPosts.get(0).getUnPostDate());
                }
            }
            PfActivityVo activityVo = super.getTaskService().getActivity(taskVo.getActivityId());
            Date taskOverTime = calendarService.getOverTime(taskVo.getBeginTime(), activityVo.getTimeLimit());
            if (hours > 0)
                taskOverTime = calendarService.getOverTime(taskOverTime, String.valueOf(hours) + "h");
            List<PfTaskVo> activityTaskList = super.getTaskService().getTaskListByActivity(activityVo.getActivityId());
            for(PfTaskVo tmpTask:activityTaskList){
                super.getTaskService().updateTaskOverTime(tmpTask.getTaskId(), taskOverTime);
            }

        }
		return true;
	}
}
