package com.gtis.plat.wf.bean;

import java.util.ArrayList;
import java.util.List;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;

public class WorkFlowTaskTurnInfoBackBean extends WorkFlowBeanAbstract {
	private static final String BACK_DEFAULT="DEFAULT";
	private static final String BACK_NONE="NOTALLOWED";
	/**
	 * 工作流的初始化工作
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		try {
			String activityDefinitionId = infoObj.getSourceActivity()
					.getActivityDefinitionId();
			// 活动模型
			WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(infoObj.getWorkFlowIntanceVo());
			ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
			//
			String backOptions=activityModel.getBackTransitions();
			if (backOptions.equalsIgnoreCase(BACK_DEFAULT)){
				List<String> backAdIdList = activityModel.getBackTransitionsList();
				if (backAdIdList != null && !backAdIdList.isEmpty()){
					List<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
					for (int i = 0; i < backAdIdList.size(); i++) {
						PfActivityVo tmpAc = new PfActivityVo();
						tmpAc.setActivityDefinitionId(backAdIdList.get(i));
						ActivityModel tmpModel = workXml.getActivity(backAdIdList.get(i));
						if (tmpModel != null){
							tmpAc.setActivityName(tmpModel.getActivityDefineName());
						}
						backActivitys.add(tmpAc);
					}
					infoObj.setTargetActivitys(backActivitys);
				}else {
					String activityId=infoObj.getSourceActivity().getActivityBefore();
					PfActivityVo aVo=super.getTaskService().getActivity(activityId);
					if (aVo!=null){
						List<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
						backActivitys.add(aVo);
						infoObj.setTargetActivitys(backActivitys);
					}
				}
			}else if (backOptions.equalsIgnoreCase(BACK_NONE)){
				return false;
			}else{
				String[] adIds=backOptions.split(",");
				List<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
				for(int i=0;i<adIds.length;i++){
					ActivityModel aModel = workXml.getActivity(adIds[i]);
                    if (aModel!=null){
                        PfActivityVo aVo=new PfActivityVo();
                        aVo.setActivityDefinitionId(aModel.getDefineId());
                        aVo.setActivityName(aModel.getActivityDefineName());
                        backActivitys.add(aVo);
                    }
				}
				infoObj.setTargetActivitys(backActivitys);
			}
		} catch (Exception e) {
			throw new WorkFlowException(
					WorkFlowException.ExceptionNum.NoBack);
		}
		return true;
	}

	
}
