package com.gtis.plat.wf.bean;

import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import org.apache.commons.lang.StringUtils;

public class WorkFlowTaskFirstBean extends WorkFlowBeanAbstract {
	
	/**
	 * 工作流的初始化工作
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		try {
			if (infoObj.getSourceTask() != null) {
				String taskId = infoObj.getSourceTask().getTaskId();
				//任务对象
				PfTaskVo taskVo = this.getTaskService().getTask(taskId);
				infoObj.setSourceTask(taskVo);
				//活动对象
				PfActivityVo activityVo = this.getTaskService().getActivity(
						taskVo.getActivityId());
				if (activityVo.getActivityState() != WorkFlowEnum.ACTIVITY_START)
					throw new WorkFlowException(
							WorkFlowException.ExceptionNum.StadusChange);
				infoObj.setSourceActivity(activityVo);
				//工作流实例对象
				PfWorkFlowInstanceVo instanceVo = this
						.getWorFlowInstanceService().getWorkflowInstance(
								activityVo.getWorkflowInstanceId());
				if (instanceVo.getWorkflowState() != WorkFlowEnum.WORKFLOW_START&&!hasSubProcess(taskId))
					throw new WorkFlowException(
							WorkFlowException.ExceptionNum.StadusChange);

				if (infoObj.getWorkFlowIntanceVo() != null && StringUtils.isNotBlank(infoObj.getWorkFlowIntanceVo().getRemark())){
					instanceVo.setRemark(infoObj.getWorkFlowIntanceVo().getRemark());
				}
				infoObj.setWorkFlowIntanceVo(instanceVo);
				//工作流定义
				PfWorkFlowDefineVo workFlowDefineVo = this
						.getWorkFlowDefineService().getWorkFlowDefine(
								instanceVo.getWorkflowDefinitionId());
				if (workFlowDefineVo == null)
					throw new WorkFlowException(
							WorkFlowException.ExceptionNum.NoDefine);
				infoObj.setWorkFlowDefineVo(workFlowDefineVo);
			}
		} catch (Exception e) {
			throw new WorkFlowException(
					WorkFlowException.ExceptionNum.StadusChange);
		}
		return true;
	}

	/**
	 * 判断当前流程是否存在子流程
	 * @param taskId
	 * @return
	 */
	private boolean hasSubProcess(String taskId){
		SysWorkFlowInstanceService sysWorkFlowInstanceService = this.getWorFlowInstanceService();
		PfWorkFlowInstanceVo subProcessInstance = sysWorkFlowInstanceService.getWorkflowInstance(taskId);
		if(subProcessInstance!=null)
			return true;
		else
			return false;
	}
}
