package com.gtis.plat.wf.bean;

import com.gtis.plat.aop.WorkflowEndAspect;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class SubProcessEndBean extends WorkFlowBeanAbstract {
    private static final Logger logger = LoggerFactory.getLogger(SubProcessEndBean.class);

    /**
     * 判断是否子流程办结，如果是需要办结主流程活动，并启动后面的活动
     * @param infoObj
     * @return
     * @throws Exception
     */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        //PfActivityVo activityVo= super.getTaskService().getActivityBySubProcessId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId());
        PfTaskVo taskVo=super.getTaskService().getTask(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId());
        if (taskVo!=null){
            try {
                PfActivityVo activityVo=super.getTaskService().getActivity(taskVo.getActivityId());

                WorkFlowCoreService workFlowCoreService=(WorkFlowCoreService) Container.getBean("WorkFlowCoreService");
                //处理主流程
                //1、还要解除挂起
                workFlowCoreService.unLockWorkFlowInstance(activityVo.getWorkflowInstanceId());
                //2、创建后面的活动
                WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo(infoObj.getUserId(),taskVo.getTaskId());
                // 处理活动
                List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();
                // /如果splittype为xor
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                ActivityModel activityModel = workXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
                if ( StringUtils.isBlank(activityModel.getSplitType()) || activityModel.getSplitType().equalsIgnoreCase("XOR")) {
                    int i = 0;
                    for (Iterator<ActivityModel> it = lstActivityModel.iterator();it.hasNext();) {
                        if (i > 0) {
//                            it.remove();
                        }
                        it.next();
                        i++;
                    }
                }

                //处理活动的子流程所属主流程下一个节点的办理人和角色信息
                Map<String,List<Map>> subProcessEndTargetActivities =infoObj.getSubProcessEndTargetActivities();
                for (Iterator<ActivityModel> it = lstActivityModel.iterator();it.hasNext();) {
                    ActivityModel tmpActivityModel = it.next();
                    if(!subProcessEndTargetActivities.containsKey(tmpActivityModel.getDefineId()))
                        it.remove();
                    else{
                        List<Map> userInfoList = subProcessEndTargetActivities.get(tmpActivityModel.getDefineId());
                        List<String> userIds = new ArrayList<String>();
                        List<String> performerIds = new ArrayList<String>();   //转发任务中，人员的部门或角色ids
                        for(Map userInfoMap: userInfoList){
                            if (userInfoMap.get("RoleId") != null&&StringUtils.isNotBlank(String.valueOf(userInfoMap.get("RoleId")))){
                                performerIds.add(String.valueOf(userInfoMap.get("RoleId")));
                                //如果id为空或者-1表示该角色下所有人
                                if (userInfoMap.get("Id")==null||StringUtils.isBlank(String.valueOf(userInfoMap.get("Id"))) || String.valueOf(userInfoMap.get("Id")).equals("-1")) {
                                    userIds.addAll(getUsersByRoleId(String.valueOf(userInfoMap.get("RoleId"))));
                                }else{
                                    userIds.add(String.valueOf(userInfoMap.get("Id")));
                                }
                            }else{
                                if (userInfoMap.get("Id")!=null&&StringUtils.isNotBlank(String.valueOf(userInfoMap.get("Id"))))
                                    userIds.add(String.valueOf(userInfoMap.get("Id")));
                            }
                        }

                        List<String> userTmpList = new ArrayList<String>();
                        List<PerformerTaskModel> lstPerformer = tmpActivityModel.getPerformerModelList();
                        //过滤用户
                        if (userIds.size() > 0) {
                            for (Iterator<PerformerTaskModel> itPerformer = lstPerformer.iterator(); itPerformer.hasNext(); ) {
                                PerformerTaskModel taskModel = itPerformer.next();
                                if (taskModel.getId() != null && !performerIds.contains(taskModel.getId())) {
                                    itPerformer.remove();
//                                    continue;
                                }
                                for (Iterator<PfUserVo> userIterator = taskModel.getUserList().iterator(); userIterator.hasNext(); ) {
                                    PfUserVo vo = (PfUserVo) userIterator.next();
                                    if (userTmpList.contains(vo.getUserId())) {
                                        userIterator.remove();
                                    } else {
                                        if (!userIds.contains(vo.getUserId())) {
                                            //taskModel.getUserList().remove(vo);
                                            userIterator.remove();
                                        } else {
                                            userTmpList.add(vo.getUserId());
                                        }
                                    }
                                }
                            }
                        }
                    }

                }
                logger.info("***Processing SubProcess end bean***");
                workFlowCoreService.postWorkFlow(infoObj.getUserId(), activityVo.getWorkflowInstanceId(), info);
            } catch (Exception e) {
                throw new WorkFlowException(WorkFlowException.ExceptionNum.MainFlowStartFailed);
            }

        }

		return true;
	}

    private List<String> getUsersByRoleId(String roleId){
        List<PfUserVo> users=super.userService.getUserListByRole(roleId);
        if (users==null || users.size()==0){
            users=super.userService.getUserListByOragn(roleId);
        }
        List<String> result=new ArrayList<String>();
        for(PfUserVo userVo:users){
            result.add(userVo.getUserId());
        }
        return result;
    }
}
