package com.gtis.plat.wf.bean;

import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.LogManager;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowPostService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.util.CalendarUtil;
import com.gtis.web.SessionUtil;

import java.util.Calendar;
import java.util.Date;

/**
 * 退件、终止工作流，不是退回，也不是删除，而是该工作流废件
 */
public class OverWorkFlowInstanceBean extends WorkFlowBeanAbstract {

    SysCalendarService calendarService;
	LogManager logManager;

    public void setCalendarService(SysCalendarService calendarService) {
        this.calendarService = calendarService;
    }

	public void setLogManager(LogManager logManager) {
		this.logManager = logManager;
	}

    /**
	 * 退件、终止工作流
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		String workflowIntanceId = infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId();
		PfWorkFlowInstanceVo intanceVo = super.getWorFlowInstanceService().getWorkflowInstance(workflowIntanceId);
		if (intanceVo.getWorkflowState() != WorkFlowEnum.WORKFLOW_OVER) {
			intanceVo.setWorkflowState(WorkFlowEnum.WORKFLOW_OVER);
			intanceVo.setFinishTime(new Date());
			super.getWorFlowInstanceService().updateWorkFlowIntanceStadus(intanceVo);

			Log log = Log.instance();
			log.setUserId(infoObj.getUserId());
			log.setAction("退件");
			log.setContent("用户退件操作");
			log.setCreateTime(new Date());
			try {
				log.setIp(Struts2Utils.getRemoteAddr());
			} catch (Exception ignored) {
			}
			PfUserVo userVo = super.getUserService().getUserVo(infoObj.getUserId());
			if (userVo != null){
				log.setContent("用户【"+userVo.getUserName()+"】于【"+ CalendarUtil.getCurHMSStrDate()+"】针对项目【"+intanceVo.getWorkflowIntanceName()+"（"+intanceVo.getWorkflowIntanceId()+"）】进行了退件操作！");
			}
			logManager.log(log);
		}else{
			throw new WorkFlowException(WorkFlowException.ExceptionNum.NoStart);
		}
		return true;
	}
}

