package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class CreateWorkFlowTaskBean extends WorkFlowBeanAbstract {

    SysCalendarService sysCalendarService;

    public void setSysCalendarService(SysCalendarService sysCalendarService) {
        this.sysCalendarService = sysCalendarService;
    }

    /**
	 * 创建工作流实例
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(infoObj
                .getWorkFlowIntanceVo());
        List<String> subProcessActivitys=new ArrayList<String>();
		//创建活动ss
		if (infoObj.getTargetActivitys() != null && infoObj.getTargetActivitys().size()>0){
			for(PfActivityVo activityVo: infoObj.getTargetActivitys()){
				//activityVo.setActivityBefore(infoObj.getSourceActivity().getActivityId());
//                if (infoObj.getSourceActivity()!=null
//                        && infoObj.getSourceActivity().isBackState()
//                        && activityVo.getActivityState()!= WorkFlowEnum.ACTIVITY_BACK)
//                    activityVo.setBackState(true);
                activityVo.setActivityState(WorkFlowEnum.ACTIVITY_START);
                //判断是否是子流程
                ActivityModel sourceActivityModel = workXml
                        .getActivity(activityVo.getActivityDefinitionId());
                if (sourceActivityModel.getSubProcess()!=null) {
                    subProcessActivitys.add(activityVo.getActivityId());
                    createSubProcess(infoObj,sourceActivityModel,activityVo);
                }
                
                // 针对 跳节点转发，会更新已有按步转发的活动开始时间的问题
                if (infoObj.getTargetTasks() != null && infoObj.getTargetTasks().size()>0){
                    for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    	System.out.println("当前活动为："+activityVo.getActivityName()+",目标活动为："+taskVo.getTaskId());
                    	if(StringUtils.equals(activityVo.getActivityId(), taskVo.getActivityId())){
                    		this.getTaskService().createActivity(activityVo);
                    	}
                    }
                }else{
                	System.out.println("没有目标任务！");
                	this.getTaskService().createActivity(activityVo);
                }
			}
		}

		//创建任务
		if (infoObj.getTargetTasks() != null && infoObj.getTargetTasks().size()>0){
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                //判断是否是子流程的任务（活动是子流程的，任务不要创建）
                if (subProcessActivitys.contains(taskVo.getActivityId()))
                    continue;
               //////判断任务是否退回任务
                List<PfTaskVo> userTasks= this.getTaskService().getHistoryTaskListByActivity(taskVo.getActivityId());
                /*if (userTasks!=null && userTasks.size()>0 && infoObj.getSourceTask()!=null && infoObj.getSourceTask().isBackState())
                    taskVo.setBackState(true);*/
                this.getTaskService().createTask(taskVo);

                PfActivityVo activityVo=this.getTaskService().getActivity(taskVo.getActivityId());
                if(activityVo!=null){
                    //判断任务是否需要委托
                    PfWorkFlowInstanceVo instanceVo=this.getWorFlowInstanceService().getWorkflowInstance(activityVo.getWorkflowInstanceId());
                    beginTrustTask(taskVo.getUserVo().getUserId(),instanceVo.getWorkflowDefinitionId() , activityVo.getActivityDefinitionId(),taskVo.getTaskId());

                    //判断任务是否需要自动挂起
                    ActivityModel sourceActivityModel = workXml
                            .getActivity(activityVo.getActivityDefinitionId());
                    String autoLock = sourceActivityModel.getAutoLock();
                    if(StringUtils.isNotBlank(autoLock)&&autoLock.equalsIgnoreCase("true")){
                        WorkFlowCoreService workFlowCoreService=(WorkFlowCoreService)Container.getBean("WorkFlowCoreService");
                        workFlowCoreService.lockWorkFlowInstance(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(),taskVo.getTaskId());
                    }
                }
            }
		}

		return true;
	}

    /**
     * 创建子流程
     * @param activityModel
     * @return
     */
    private String createSubProcess(WorkFlowInfo infoObj,ActivityModel activityModel,PfActivityVo targetActivity){
        try {
            PfWorkFlowDefineVo workFlowDefineVo= super.getWorkFlowDefineService().getWorkFlowDefine(activityModel.getSubProcess().getId());
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
//			ServletActionContext.getRequest().setCharacterEncoding("GBK");
            String proId = UUIDGenerator.generate();
            intanceVo.setWorkflowDefinitionId(workFlowDefineVo.getWorkflowDefinitionId());
            intanceVo.setWorkflowIntanceId(proId);
            intanceVo.setProId(proId);
            intanceVo.setCreateTime(Calendar.getInstance().getTime());
            intanceVo.setTimeLimit(workFlowDefineVo.getTimeLimit());
            intanceVo.setDistrict(infoObj.getWorkFlowIntanceVo().getDistrict());
            String subName=infoObj.getWorkFlowIntanceVo().getWorkflowIntanceName().split("_")[0] +"_" + workFlowDefineVo.getWorkflowName();
            intanceVo.setWorkflowIntanceName(subName);

            String userid = infoObj.getUserId();
            PfUserVo userVo = new PfUserVo();
            userVo.setUserId("-1");
            if ((infoObj.getTargetTasks() != null) && (infoObj.getTargetTasks().size() > 0)) {
                userid = ((PfTaskVo)infoObj.getTargetTasks().get(0)).getUserVo().getUserId();
                userVo.setUserId(userid);
            }
            WorkFlowCoreService workFlowCoreService = (WorkFlowCoreService)Container.getBean("WorkFlowCoreService");

            HashMap paramMap = new HashMap();
            if ((infoObj.getTargetTasks() != null) && (infoObj.getTargetTasks().size() > 1)) {
                List<String> selectUserList = new ArrayList<String>();
                for (int i = 1; i < infoObj.getTargetTasks().size(); i++) {
                    selectUserList.add(infoObj.getTargetTasks().get(i).getUserVo().getUserId());
                }
                paramMap.put("selectUserList",selectUserList);
            }
            intanceVo.setExtensionMap(paramMap);
            workFlowCoreService.createWorkFlowInstance(intanceVo, userid);

            //创建活动是子流程时候对应的任务
            PfTaskVo taskVo=new PfTaskVo();
            taskVo.setTaskId(proId);
            taskVo.setActivityId(targetActivity.getActivityId());

            taskVo.setUserVo(userVo);
            taskVo.setBeginTime(Calendar.getInstance().getTime());
            taskVo.setOverTime(sysCalendarService.getOverTime(taskVo.getBeginTime(), targetActivity.getTimeLimit()));
            this.getTaskService().createTask(taskVo);
            if (activityModel.getSubProcess().isLockParentProject()){
                //挂起主流程
                workFlowCoreService.lockWorkFlowInstance(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(),intanceVo.getWorkflowIntanceId());
            }
            SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService = (SysWorkFlowInstanceRelService) Container.getBean("SysWorkFlowInstanceServiceRelImpl");
            sysWorkFlowInstanceRelService.insertWorkFlowRel(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(),intanceVo.getWorkflowIntanceId());
//            if (StringUtils.isBlank(workFlowDefineVo.getTimeLimit()) || workFlowDefineVo.getTimeLimit().equals("0")){
//
//            }else {
//                this.getTaskService().updateTaskOverTime(taskVo.getTaskId(),intanceVo.getOverTime());
//            }
            return intanceVo.getWorkflowIntanceId();
        } catch (Exception e) {
            throw new WorkFlowException(WorkFlowException.ExceptionNum.SubFlowStartFailed);
        }
    }

    private void beginTrustTask(String userId,String workflowDefineId,String activityDefineId,String taskId) throws Exception{
        String trustUserId=getTrustAgentUserId(userId,workflowDefineId,activityDefineId);
        if (StringUtils.isNotBlank(trustUserId)){
            WorkFlowCoreService workFlowCoreService=(WorkFlowCoreService)Container.getBean("WorkFlowCoreService");
            workFlowCoreService.entrustTask(taskId,trustUserId);
        }
    }
    /**
     * 查找任务的委托人
     * @param userId
     * @param workflowDefineId
     * @param activityDefineId
     * @return
     */
    private String getTrustAgentUserId(String userId,String workflowDefineId,String activityDefineId){
        String trustAgentUserId=null;
        List<PfTaskAgentVo> agentUsers=this.userService.getTaskAgentListByUser(userId);
        if (agentUsers!=null){
            for(PfTaskAgentVo taskAgentVo:agentUsers){
                if (taskAgentVo.getWorkFlowDefinitionId()==null || taskAgentVo.getWorkFlowDefinitionId().equals(workflowDefineId)){
                    if (StringUtils.isBlank(taskAgentVo.getActivityDefinitionId()) ||
                            taskAgentVo.getActivityDefinitionId().equals(activityDefineId)){
                        if (taskAgentVo.getBeginTime()==null || taskAgentVo.getBeginTime().before(Calendar.getInstance().getTime()) ){
                            if (taskAgentVo.getEndTime()==null || taskAgentVo.getEndTime().after(Calendar.getInstance().getTime()) ){
                                if(1==taskAgentVo.getAgentType()){  //判断是否为委托类型
                                   trustAgentUserId= taskAgentVo.getUserId();
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        return trustAgentUserId;
    }

}
