package com.gtis.plat.wf.bean;

import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.*;
import com.gtis.util.CalendarUtil;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateWorkFlowInstanceBean extends WorkFlowBeanAbstract {
	
	/**
	 * 创建工作流实例
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		if (infoObj.getWorkFlowIntanceVo() != null){
			//设置创建人
			infoObj.getWorkFlowIntanceVo().setCreateUser(infoObj.getUserId());
			//默认状态
			infoObj.getWorkFlowIntanceVo().setWorkflowState(WorkFlowEnum.WORKFLOW_START);
			//默认优先级
			if (infoObj.getWorkFlowIntanceVo().getPriority()==null)
				infoObj.getWorkFlowIntanceVo().setPriority("1");
			
			// 处理地区编码
			if (infoObj.getWorkFlowIntanceVo().getRegionCode() == null) {
				String regionCode = this.getUserService().getUserRegionCode(infoObj.getUserId());
				infoObj.getWorkFlowIntanceVo().setRegionCode(regionCode);
			}
			infoObj.getWorkFlowIntanceVo().setRemark(initQRCode(infoObj.getWorkFlowIntanceVo(),infoObj.getWorkFlowDefineVo()));
			this.getWorFlowInstanceService().createWorkFlowIntance(
					infoObj.getWorkFlowIntanceVo());
			
			if (infoObj.getTargetActivitys() == null || infoObj.getTargetActivitys().size()==0){
				throw new WorkFlowException(WorkFlowException.ExceptionNum.NoActivty);
			}
			if (infoObj.getTargetTasks() == null || infoObj.getTargetTasks().size()==0){
				throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
			}
		}
		return true;
	}

	private String initQRCode(PfWorkFlowInstanceVo workFlowInstanceVo, PfWorkFlowDefineVo workFlowDefineVo){
		if (StringUtils.isBlank(workFlowInstanceVo.getRemark())){
			try {
				WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
				//使用备注字段存储二维码信息
				String useRemarkSaveQRCode = workFlowXml.getExtendedAttribute("UseRemarkSaveQRCode")+"";
				if (StringUtils.equalsIgnoreCase("true",useRemarkSaveQRCode)){
					/**
					 * 受理编号的处理逻辑：
					 * 苏州的二维码处理逻辑是16位编码，分别是年份、月份、行政区、业务编码、序号，对应的位数是4/2/2/3/5，比如：2018 01 01 101 00001，不要空格
					 * 根据年份、月份、行政区、工作流定义的编码，查找最大的工作流编号，之后续编
					 */
					String qrCode = CalendarUtil.sdf_YM.format(CalendarUtil.getCurDate());
					String xzqdm = StringUtils.isBlank(workFlowInstanceVo.getRegionCode())?AppConfig.getProperty("district.code"):workFlowInstanceVo.getRegionCode();
					qrCode += StringUtils.substring(xzqdm,4,6);
					qrCode += StringUtils.isBlank(workFlowDefineVo.getWorkflowCode())?"000":workFlowDefineVo.getWorkflowCode();

					HashMap param = new HashMap();
					param.put("REMARK",qrCode);
					Object curMaxBh = workFlowInstanceExtDao.getObjectByIbatis(param,"getMaxQrCode_suzhou");
					if (curMaxBh != null && StringUtils.isNotBlank(curMaxBh.toString()) && StringUtils.length(curMaxBh.toString()) == 16){
						String curBhLsh = StringUtils.substring(curMaxBh.toString(),11,16);
						if (StringUtils.equals(curBhLsh,getIntegerStr(curBhLsh))){
							Integer newBh = Integer.parseInt(curBhLsh)+1;
							qrCode += String.format("%05d", newBh);
							return qrCode;
						}
					}else {
						qrCode += "00001";
						return qrCode;
					}
				}
			}catch (Exception ex){
				ex.printStackTrace();
			}
		}
		return workFlowInstanceVo.getRemark();
	}

	/**
	 * 获取字符串中的整数部分
	 * @param str
	 * @return
	 */
	public String getIntegerStr(String str){
		String numberRegEx = "[^0-9]";
		Pattern pattern = Pattern.compile(numberRegEx);
		Matcher matcher = pattern.matcher(str);
		String result = matcher.replaceAll("");
		return result;
	}
	/**
	 * 获取字符串中的数字部分
	 * @param str
	 * @return
	 */
	public String getNumberStr(String str){
		String numberRegEx = "([^(\\d|\\.)])";
		Pattern pattern = Pattern.compile(numberRegEx);
		Matcher matcher = pattern.matcher(str);
		String result = matcher.replaceAll("");
		return result;
	}

}
