package com.gtis.plat.wf;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.spring.Container;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WorkFlowUtil {
	private static final String TEMP_TASK_LAST = "TEMP";

	public static String buildTEMPActivityId(String activityId){
		StringBuffer result=new StringBuffer("");
		if (activityId.length()>TEMP_TASK_LAST.length()){
			result.append(activityId.substring(0, activityId.length()-TEMP_TASK_LAST.length()));
		}
			result.append(TEMP_TASK_LAST);
		return result.toString();
	}

	/**
	 * 根据任务id，获取当前节点的配置角色列表
	 * @param taskid
	 * @param taskService
	 * @param workFlowInstanceService
	 * @return
	 */
	public static List<String> getActivityRolesByTaskId(String taskid,SysTaskService taskService,SysWorkFlowInstanceService workFlowInstanceService){
		List<String> activityRoles =new ArrayList<String>();
		if (StringUtils.isNotBlank(taskid)){
			PfTaskVo taskVo = taskService.getTask(taskid);
			if (taskVo != null){
				PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
				if (activityVo != null){
					PfWorkFlowInstanceVo workFlowInstanceVo = workFlowInstanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
					WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
					ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
					//获取活动role
					List<PerformerModel> performerList = aModel.getPerformerList();
					if(CollectionUtils.isNotEmpty(performerList)){
						for (PerformerModel performerModel:performerList){
							activityRoles.add(performerModel.getRoleId());
						}
					}
				}
			}
		}
		return activityRoles;
	}

	public static void clearCache(String name){
		CacheManager cacheManager = (CacheManager) Container.getBean("ehCacheManager");
		if (StringUtils.isNotBlank(name)){
			Cache cache = cacheManager.getCache(name);
			cache.removeAll();
		}else {
			cacheManager.clearAll();
		}
	}
}
