package com.gtis.plat.wf;

public class WorkFlowException extends RuntimeException{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5983419223219081764L;
	private String exceptionString;

	public enum ExceptionNum {
		NoDefine, NoUsers, NoId, NoActivty, StadusChange, CooperatNotEnd, CooperatAlready, CooperatAndOthers,
        NoBack,AlreadyHandle,AlreadyStop,NoStart,ParentActivitysNoFinish,NoRetrieve,SubFlowStartFailed,MainFlowStartFailed
	}

	public WorkFlowException() {
		exceptionString = "工作流引擎错误！";
	}

	public WorkFlowException(String message) {
		exceptionString = message;
	}

	public WorkFlowException(ExceptionNum num) {
		switch (num) {
		case NoDefine:
			exceptionString = "工作流定义不存在！";
			break;
		case NoUsers:
			exceptionString = "活动没有参与者！";
			break;
		case NoId:
			exceptionString = "工作流没有编号！";
			break;
		case StadusChange:
			exceptionString = "流程状态已经发生变化，需要重新办理！";
			break;
		case CooperatNotEnd:
			exceptionString = "协办活动没有办结，不能转发！";
			break;
		case NoActivty:
			exceptionString = "没有可创建活动，请检查工作流设置！";
			break;
		case CooperatAlready:
			exceptionString = "协办活动已经存在不能转发！";
			break;
		case CooperatAndOthers:
			exceptionString = "协办活动和其他非协办不能同时转发！";
			break;
		case NoBack:
			exceptionString = "当前活动无法退回！";
			break;
		case AlreadyStop:
			exceptionString = "当前任务已经挂起！";
			break;
        case AlreadyHandle:
			exceptionString = "任务正在办理！";
			break;
        case NoStart:
			exceptionString = "项目不在活动状态！";
			break;
        case ParentActivitysNoFinish:
            exceptionString ="活动还没有办结，请检查！";
            break;
        case SubFlowStartFailed:
            exceptionString ="子流程启动失败，请检查！";
            break;
        case MainFlowStartFailed:
            exceptionString ="子流程办结，但返回主流程失败，请检查！";
            break;
        case NoRetrieve:
            exceptionString="无法取回项目！";
            break;
		default:
			exceptionString = "其他错误";
			break;
		}
	}

	@Override
	public String toString() {
		return exceptionString;

	}

	@Override
	public String getMessage() {
		return exceptionString;
	}

}
