package com.gtis.plat.wf;

import com.gtis.common.util.CommonUtil;
import com.gtis.config.AppConfig;
import com.gtis.generic.util.SpringContextUtils;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.util.CalendarUtil;
import com.gtis.web.SessionUtil;
import net.sf.ehcache.CacheManager;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.util.*;

public class WorkFlowCoreServiceImpl implements WorkFlowCoreService {

    private Map<String,String> smsTemplate;

    private SysSmsService smsService;

    private SysUserService userService;

    private SysActivityService sysActivityService;

    private SysTaskService taskService;

    private SysWorkFlowInstanceService sysWorkFlowInstanceService;

    private SysWorkFlowDefineService sysWorkFlowDefineService;

    private SysSubProcessService sysSubProcessService;

    private List<WorkFlowBean> createWorkFlowBeans;

    private List<WorkFlowBean> getWorkFlowTurnInfoBeans;

    private List<WorkFlowBean> getWorkFlowTurnBackInfoBeans;

    private List<WorkFlowBean> turnWorkFlowBeans;

    private List<WorkFlowBean> delWorkFlowBean;

    private List<WorkFlowBean> lockWorkFlowBean;

    private List<WorkFlowBean> overWorkFlowBean;

    private List<WorkFlowBean> unLockWorkFlowBean;

    private List<WorkFlowBean> finishWorkFlowBean;

    private List<WorkFlowBean> turnBackWorkFlowBeans;

    private List<WorkFlowBean> retrieveWorkFlowBeans;

    private List<WorkFlowBean> restartWorkFlowBeans;

    private List<WorkFlowBean> entrustWorkFlowBeans;

    private CacheManager cacheManager;

    public void setEntrustWorkFlowBeans(List<WorkFlowBean> entrustWorkFlowBeans) {
        this.entrustWorkFlowBeans = entrustWorkFlowBeans;
    }

    public List<WorkFlowBean> getRetrieveWorkFlowBeans() {
        return retrieveWorkFlowBeans;
    }

    public void setRetrieveWorkFlowBeans(List<WorkFlowBean> retrieveWorkFlowBeans) {
        this.retrieveWorkFlowBeans = retrieveWorkFlowBeans;
    }

    static Log log = LogFactory.getLog(WorkFlowCoreServiceImpl.class);


    /**
     * 委托任务
     * @param taskId
     * @param trustUserId 被委托人
     * @return
     * @throws Exception
     */
    public boolean entrustTask(String taskId,String trustUserId) throws Exception{
        if (entrustWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(trustUserId);
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);


            try {
                getWorkFlowCoreService().doWorkBeans(infoObj, entrustWorkFlowBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                } else {
                    throw e;
                }
                return false;
            }
        }
        return true;
    }

    /**
     * 创建工作流
     */
    public WorkFlowInfo createWorkFlowInstance(
            PfWorkFlowInstanceVo workFlowIntanceVo, String userId)
            throws Exception {
        if (createWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                getWorkFlowCoreService().doWorkBeans(infoObj, createWorkFlowBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                } else {
                    throw e;
                }
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getCreateWorkFlowBeans() {
        return createWorkFlowBeans;
    }

    public void setCreateWorkFlowBeans(List<WorkFlowBean> createWorkFlowBeans) {
        this.createWorkFlowBeans = createWorkFlowBeans;
    }


    /**
     * 任务转发信息
     */
    public WorkFlowInfo getWorkFlowTurnInfo(String userId, String taskId) throws Exception {
        if (getWorkFlowTurnInfoBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            try {
                getWorkFlowCoreService().doWorkBeans(infoObj, getWorkFlowTurnInfoBeans);
            } catch (Exception e) {
                throw e;
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getGetWorkFlowTurnInfoBeans() {
        return getWorkFlowTurnInfoBeans;
    }

    public void setGetWorkFlowTurnInfoBeans(
            List<WorkFlowBean> getWorkFlowTurnInfoBeans) {
        this.getWorkFlowTurnInfoBeans = getWorkFlowTurnInfoBeans;
    }

    /**
     * 工作流转发
     */
    public boolean postWorkFlow(String userId, String taskId, WorkFlowInfo infoObj)
            throws Exception {
        if (turnWorkFlowBeans != null && turnWorkFlowBeans.size()>0) {
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, turnWorkFlowBeans);
            } catch (Exception e) {
                throw e;
            }
        }
        return false;
    }

    /**
     * 工作流退回
     */
    public boolean postBackWorkFlow(String userId, String taskId, String[] backDefineActivitys, String remark) throws Exception {
        if (turnBackWorkFlowBeans != null) {
            try {
                WorkFlowInfo infoObj = new WorkFlowInfo();
                infoObj.setUserId(userId);
                /////退回备注
                WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
                transInfo.setRemark(remark);
                infoObj.setTransInfo(transInfo);
                /////
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
                List<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
                for (int i = 0; i < backDefineActivitys.length; i++) {
                    PfActivityVo aVo = new PfActivityVo();
                    aVo.setActivityDefinitionId(backDefineActivitys[i]);
                    backActivitys.add(aVo);
                }
                infoObj.setTargetActivitys(backActivitys);
                return getWorkFlowCoreService().doWorkBeans(infoObj, turnBackWorkFlowBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    log.error("-----工作流引擎错误：" + e.getMessage(), e);
                    throw e;
                }

            }
        }
        return false;
    }

    /**
     * 工作流退回
     * 根据前台选择的人员信息进行退回，传递的map中包含了退回目标节点的id和对应的节点参与人员id
     */
    public boolean postBackWorkFlow(String userId, String taskId, HashMap<String,String> selectAcMap, String remark) throws Exception {
        if (turnBackWorkFlowBeans != null) {
            try {
                WorkFlowInfo infoObj = new WorkFlowInfo();
                infoObj.setUserId(userId);
                /////退回备注
                WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
                transInfo.setRemark(remark);
                infoObj.setTransInfo(transInfo);
                /////
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
                List<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
                for(Map.Entry<String,String> entry:selectAcMap.entrySet()){
                    PfActivityVo aVo = new PfActivityVo();
                    aVo.setActivityDefinitionId(entry.getKey());
                    backActivitys.add(aVo);
                }
                infoObj.setTargetActivitys(backActivitys);
                infoObj.setSelectAcMap(selectAcMap);
                return getWorkFlowCoreService().doWorkBeans(infoObj, turnBackWorkFlowBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    log.error("-----工作流引擎错误：" + e.getMessage(), e);
                    throw e;
                }

            }
        }
        return false;
    }

    /**
     * 工作流重新开始
     *
     * @param userId
     * @param wiid
     * @param remark
     * @return
     * @throws Exception
     */
    public boolean restartWorkFlow(String userId, String wiid, String remark) throws Exception {
        if (restartWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            /////重新开始备注
            WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
            transInfo.setRemark(remark);
            infoObj.setTransInfo(transInfo);
            /////
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
            intanceVo.setWorkflowIntanceId(wiid);
            infoObj.setWorkFlowIntanceVo(intanceVo);
            return getWorkFlowCoreService().doWorkBeans(infoObj, restartWorkFlowBeans);
        }
        return false;
    }

    public boolean turnTask(Document doc, String taskId) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = getWorkFlowTurnInfo(userId, taskId);
        WorkFlowXml xmlUtil = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlUtil.getActivity(info.getSourceActivity().getActivityDefinitionId());
//        doc = httpFilterXml(doc,activityModel);
        List<Node> activityList = doc.selectNodes("//Activity");
        List<String> activitys = new ArrayList<String>();
        Map<String,List<Map>> subProcessEndTargetActivities = new HashMap<String, List<Map>>();
        Boolean isSubProcessFinishing = sysSubProcessService.isSubProcessFinishing(taskId);

        //只有满足条件才能转发，避免转发目标人员为空导致没有待办任务
        //如果是办结操作，则允许执行转发
        boolean canturn = false;
        if (activityList == null || activityList.isEmpty()){
            //相当于没有目标节点，算是办结操作
            canturn = true;
        }

        for (Node node : activityList) {
            String nodeId = node.valueOf("@Id");
            activitys.add(nodeId);
            if (StringUtils.equals(nodeId,"-1")){
                //中间节点选择了办结操作
                canturn = true;
            }

            if(isSubProcessFinishing){
                List<Node> lstUser = (List<Node>) doc.selectNodes("//Activity[@Id='"
                        + node.valueOf("@Id") + "']/UserInfo");
                List<Map> userInfoList = new ArrayList<Map>();
                for(Node userNode : lstUser){
                    Map userInfoMap = new HashMap();
                    String ids = userNode.valueOf("@Id");
                    String[] idAry = StringUtils.split(ids,",");
                    for (int i = 0; i < idAry.length; i++) {
                        userInfoMap = new HashMap();
                        userInfoMap.put("Id",idAry[i].trim());
                        userInfoMap.put("RoleId",userNode.valueOf("@RoleId"));
                        userInfoList.add(userInfoMap);
                    }
                }
                subProcessEndTargetActivities.put(node.valueOf("@Id"),userInfoList);
                info.setSubProcessEndTargetActivities(subProcessEndTargetActivities);
            }
        }

        //处理活动
        List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();
        if (lstActivityModel == null || lstActivityModel.isEmpty()){
            //相当于没有目标节点，算是办结操作
            canturn = true;
        }
        for (Iterator<ActivityModel> itModel = lstActivityModel.iterator(); itModel.hasNext(); ) {
            ActivityModel model = itModel.next();
            if (!activitys.contains(model.getDefineId())) {
                itModel.remove();
            } else {
                //处理活动中的任务
                List<PerformerTaskModel> lstPerformer = model.getPerformerModelList();
                List<Node> lstUser = (List<Node>) doc.selectNodes("//Activity[@Id='"
                        + model.getDefineId() + "']/UserInfo");
                List<String> userIds = new ArrayList<String>();
                List<String> performerIds = new ArrayList<String>();   //转发任务中，人员的部门或角色ids
                for (Node node : lstUser) {
                    if (node.valueOf("@RoleId") != null){
                        performerIds.add(node.valueOf("@RoleId"));
                        //如果id为空或者-1表示该角色下所有人
                        if (StringUtils.isBlank(node.valueOf("@Id")) || node.valueOf("@Id").equals("-1")) {
                            userIds.addAll(getUsersByRoleId(node.valueOf("@RoleId")));
                        }else{
                            String ids = node.valueOf("@Id");
                            if (!StringUtils.equalsIgnoreCase(ids,"nouser")){
                                String[] idAry = StringUtils.split(ids,",");
                                for (int i = 0; i < idAry.length; i++) {
                                    userIds.add(idAry[i].trim());
                                }
                            }
                        }
                    }else{
                        //针对前台传递过来无效的用户信息进行过滤
                        if (StringUtils.isNotBlank(node.valueOf("@Id"))){
                            String ids = node.valueOf("@Id");
                            String[] idAry = StringUtils.split(ids,",");
                            for (int i = 0; i < idAry.length; i++) {
                                userIds.add(idAry[i].trim());
                            }
                        }
                            //userIds.add(node.valueOf("@Id"));
                    }
                }
                List<String> userTmpList = new ArrayList<String>();
                //过滤用户
                if (userIds.size() > 0) {
                    //for(PerformerTaskModel taskModel:lstPerformer){
                    for (Iterator<PerformerTaskModel> itPerformer = lstPerformer.iterator(); itPerformer.hasNext(); ) {
                        PerformerTaskModel taskModel = itPerformer.next();
                        if (taskModel.getId() != null && !performerIds.contains(taskModel.getId())) {
                            itPerformer.remove();
                            continue;
                        }
                        for (Iterator<PfUserVo> it = taskModel.getUserList().iterator(); it.hasNext(); ) {
                            PfUserVo vo = (PfUserVo) it.next();
                            if (userTmpList.contains(vo.getUserId())) {
                                it.remove();
                            } else {
                                if (!userIds.contains(vo.getUserId())) {
                                    //taskModel.getUserList().remove(vo);
                                    it.remove();
                                } else {
                                    userTmpList.add(vo.getUserId());
                                }
                            }
                        }
                    }
                }
                if (userTmpList.size() > 0){
                    canturn  = true;
                }
            }
        }
        if (canturn){
            // 备注
            Node remarkNode = doc.selectSingleNode("//ReMark/text");
            if (remarkNode != null) {
                if (!"".equals(remarkNode.getText().trim()))
                    info.getTransInfo().setRemark(remarkNode.getText());
            }
            //开始转发
            getWorkFlowCoreService().postWorkFlow(userId, taskId, info);

            boolean  sendSms="always".equalsIgnoreCase(activityModel.getIsSendSMS());
            if (Boolean.parseBoolean(doc.selectSingleNode("/Activitys").valueOf("@SendSMS")) || sendSms) {
                sendTaskSMS(info);
            }
        }

        return false;
    }
    /**
     * 根据角色id或者所有的人
     * @param roleId
     * @return
     */
    private List<String> getUsersByRoleId(String roleId){
        List<PfUserVo> users=userService.getUserListByRole(roleId);
        if (users==null || users.size()==0){
            users=userService.getUserListByOragn(roleId);
        }
        List<String> result=new ArrayList<String>();
        //判断是否配置了去掉重复人员的选项
        String curUserId = SessionUtil.getCurrentUserId();
        boolean removeRepearUser = AppConfig.getBooleanProperty("platform.workflow.turn.remove.repeat.user");
        //只有人员数量大于一，并且允许去除重复才进行处理
        if (users.size() > 1 && removeRepearUser){
            removeRepearUser = true;
        }

        for(PfUserVo userVo:users){
            if (!(StringUtils.equals(userVo.getUserId(),curUserId) && removeRepearUser)){
                result.add(userVo.getUserId());
            }
        }
        return result;
    }
    
    public void setRestartWorkFlowBeans(List<WorkFlowBean> restartWorkFlowBeans) {
        this.restartWorkFlowBeans = restartWorkFlowBeans;
    }

    /**
     * 删除工作流实例
     */
    public boolean deleteWorkFlowInstance(String userId, String workflowIntanceId) throws Exception {
        if (delWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = sysWorkFlowInstanceService.getWorkflowInstance(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            infoObj.setUserId(userId);
            infoObj.setWorkFlowDefineVo(sysWorkFlowDefineService.getWorkFlowDefine(workFlowIntanceVo.getWorkflowDefinitionId()));
            try {
                return getWorkFlowCoreService().deleteWorkFlowInstance(infoObj);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    throw e;
                }
            }
        }
        return false;
    }
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2018/4/21
     * @param infoObj
     * @return
     * @description 删除工作流实例
     */
    public boolean deleteWorkFlowInstance(WorkFlowInfo infoObj) throws Exception {
        return getWorkFlowCoreService().doWorkBeans(infoObj, delWorkFlowBean);
    }

    public List<WorkFlowBean> getTurnWorkFlowBeans() {
        return turnWorkFlowBeans;
    }

    public void setTurnWorkFlowBeans(List<WorkFlowBean> turnWorkFlowBeans) {
        this.turnWorkFlowBeans = turnWorkFlowBeans;
    }

    public List<WorkFlowBean> getDelWorkFlowBean() {
        return delWorkFlowBean;
    }

    public void setDelWorkFlowBean(List<WorkFlowBean> delWorkFlowBean) {
        this.delWorkFlowBean = delWorkFlowBean;
    }

    public boolean overWorkFlowInstance(String workflowIntanceId, HashMap param) throws Exception {
        if (overWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            infoObj.setUserId(SessionUtil.getCurrentUserId());
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, overWorkFlowBean);
            } catch (Exception e) {
//				log.error("-----工作流引擎错误：",e);
                throw e;
            }
        }
        return false;
    }

    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId, String remark) throws Exception {
        if (lockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            if (taskId != null && !taskId.equals("")) {
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
            }
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            workFlowIntanceVo.setRemark(remark);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            infoObj.setUserId(SessionUtil.getCurrentUserId());
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, lockWorkFlowBean);
            } catch (Exception e) {
				log.error("-----工作流引擎错误：",e);
            }
        }
        return false;
    }

    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId, String reMark, String userId) throws Exception {
        if (lockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            if (taskId != null && !taskId.equals("")) {
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
            }
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            workFlowIntanceVo.setRemark(reMark);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            infoObj.setUserId(userId);
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, lockWorkFlowBean);
            } catch (Exception e) {
                log.error("-----工作流引擎错误：",e);
            }
        }
        return false;
    }

    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId) throws Exception {
        if (lockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            if (taskId != null && !taskId.equals("")) {
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
            }
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, lockWorkFlowBean);
            } catch (Exception e) {
                log.error("-----工作流引擎错误：", e);
            }
        }
        return false;
    }

    public boolean unLockWorkFlowInstance(String workflowIntanceId) throws Exception {
        if (unLockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, unLockWorkFlowBean);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    throw e;
                }
            }
        }
        return false;
    }

    public List<WorkFlowBean> getLockWorkFlowBean() {
        return lockWorkFlowBean;
    }

    public void setLockWorkFlowBean(List<WorkFlowBean> lockWorkFlowBean) {
        this.lockWorkFlowBean = lockWorkFlowBean;
    }

    public List<WorkFlowBean> getUnLockWorkFlowBean() {
        return unLockWorkFlowBean;
    }

    public void setUnLockWorkFlowBean(List<WorkFlowBean> unLockWorkFlowBean) {
        this.unLockWorkFlowBean = unLockWorkFlowBean;
    }

    public boolean finishWorkFlow(WorkFlowInfo infoObj) throws Exception {
        if (finishWorkFlowBean != null) {
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, finishWorkFlowBean);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    throw e;
                }
            }
        }
        return false;
    }

    public boolean finishWorkFlow(String workflowIntanceId) throws Exception {
        if (finishWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = sysWorkFlowInstanceService.getWorkflowInstance(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            infoObj.setUserId(SessionUtil.getCurrentUserId());
            infoObj.setWorkFlowDefineVo(sysWorkFlowDefineService.getWorkFlowDefine(workFlowIntanceVo.getWorkflowDefinitionId()));
            finishWorkFlow(infoObj);
        }
        return false;
    }

    public List<WorkFlowBean> getFinishWorkFlowBean() {
        return finishWorkFlowBean;
    }

    public void setFinishWorkFlowBean(List<WorkFlowBean> finishWorkFlowBean) {
        this.finishWorkFlowBean = finishWorkFlowBean;
    }

    @Transactional
    public boolean doWorkBeans(WorkFlowInfo infoObj, List<WorkFlowBean> beans) throws Exception {
        try {
            for (WorkFlowBean step : beans) {
                boolean result = step.doWork(infoObj);
                if (!result) return false;
            }
            return true;
        } catch (Exception e) {
            throw e;
        }
    }


    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2018/4/21
     * @param
     * @return
     * @description 获取Spring容器托管的代理对象，以解决类内部方法使用AOP注解或XML配置时不生效的问题
     */
    private WorkFlowCoreServiceImpl getWorkFlowCoreService(){
        return SpringContextUtils.getApplicationContext().getBean(this.getClass());
    }

    /**
     * 返回可以退回的活动id和名称
     */
    public WorkFlowInfo getWorkFlowTurnBackInfo(String userId, String taskId)
            throws Exception {
        if (getWorkFlowTurnBackInfoBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            try {
                getWorkFlowCoreService().doWorkBeans(infoObj, getWorkFlowTurnBackInfoBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                } else {
                    throw e;
                }
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getGetWorkFlowTurnBackInfoBeans() {
        return getWorkFlowTurnBackInfoBeans;
    }

    public void setGetWorkFlowTurnBackInfoBeans(
            List<WorkFlowBean> getWorkFlowTurnBackInfoBeans) {
        this.getWorkFlowTurnBackInfoBeans = getWorkFlowTurnBackInfoBeans;
    }

    public List<WorkFlowBean> getTurnBackWorkFlowBeans() {
        return turnBackWorkFlowBeans;
    }

    public void setTurnBackWorkFlowBeans(List<WorkFlowBean> turnBackWorkFlowBeans) {
        this.turnBackWorkFlowBeans = turnBackWorkFlowBeans;
    }

    public boolean retrieveWorkFlow(String userId, String taskId) throws Exception {
        if (this.retrieveWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            try {
                return getWorkFlowCoreService().doWorkBeans(infoObj, this.retrieveWorkFlowBeans);
            } catch (Exception e) {
                throw e;
            }
        }
        return false;
    }

    /**
     * 短信发送
     *
     * @param info
     */
    private void sendTaskSMS(WorkFlowInfo info) {

//        List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();
//        for (Iterator<ActivityModel> itModel = lstActivityModel.iterator(); itModel.hasNext(); ) {
//            ActivityModel model = itModel.next();
//            model.get
//        }
    	 //---add 2019-02-20  增加当前转发人参数
    	String currUserId  = info.getUserId();
    	String currUserName  = "";
    	System.out.println("当前的userId：" + currUserId);
    	PfUserVo currUser = userService.getUserVo(currUserId);
    	if(null != currUser){
    		currUserName = currUser.getUserName();
    		System.out.println("当前的用户名：" + currUserName);
    	}
    	 //---add 2019-02-20  增加当前转发人参数
    	
        List<PfTaskVo> taskList = info.getTargetTasks();
        HashMap praseMap = new HashMap();
        praseMap.put("workflowName", info.getWorkFlowIntanceVo().getWorkflowIntanceName());
//            praseMap.put("createUser", SessionUtil.getUserName(ServletActionContext.getRequest()));
        praseMap.put("createTime", CommonUtil.formateDate(info.getWorkFlowIntanceVo().getCreateTime()));
        //new add 2019-03-20，对于紧急程度字段的添加
        String priority = "普通件";
        if(StringUtils.isNotBlank(info.getWorkFlowIntanceVo().getPriority())){
            if(info.getWorkFlowIntanceVo().getPriority().equals("2")){
                priority = "紧急件";
            }else if(info.getWorkFlowIntanceVo().getPriority().equals("3")){
                priority = "特急件";
            }
        }
        praseMap.put("priority", priority);
        StrSubstitutor sub = new StrSubstitutor(praseMap, "%{", "}");
        PfWorkFlowDefineVo pfWorkFlowDefineVo = info.getWorkFlowDefineVo();

        WorkFlowXml xmlUtil = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        HashMap extAttrMap = xmlUtil.getExtendedAttributeMap();
        //获取TempTaskNoSendMsg拓展属性，标示该工作流针对临时任务不发送短信
        boolean tempTaskNoSendMsg = MapUtils.getBoolean(extAttrMap,"TempTaskNoSendMsg",false);
        for (PfTaskVo task : taskList) {
            PfActivityVo pfActivityVo = sysActivityService.getActivityById(task.getActivityId());
            ActivityModel activityModel = xmlUtil.getActivity(info.getSourceActivity().getActivityDefinitionId());
            //获取TempTaskNoSendMsg拓展属性，标示该工作流针对临时任务不发送短信
            boolean acTempTaskNoSendMsg = MapUtils.getBoolean(activityModel.getExtendedAttributeMap(),"TempTaskNoSendMsg",false);
            //此时需要判断生成的任务是否是临时任务
            //查询该操作生成任务记录是否是临时任务，根据节点id是否有TEMP后缀来决定，也就是目标节点的任务
            if (tempTaskNoSendMsg || acTempTaskNoSendMsg){
                String tmpAcid = WorkFlowUtil.buildTEMPActivityId(task.getActivityId());
                if (StringUtils.equals(task.getActivityId(),tmpAcid)){
                    continue;
                }
            }

            PfUserVo user = userService.getUserVo(task.getUserVo().getUserId());

            //---add 2018-10-08 判断该任务是否被委托
            String trustAgentUserId = null;
            List<PfTaskAgentVo> agentUsers = this.userService.getTaskAgentListByUser(user.getUserId());
            if (agentUsers != null) {
                for (PfTaskAgentVo taskAgentVo : agentUsers) {
                    if (taskAgentVo.getWorkFlowDefinitionId() == null || taskAgentVo.getWorkFlowDefinitionId().equals(info.getWorkFlowIntanceVo().getWorkflowDefinitionId())) {
                        if (StringUtils.isBlank(taskAgentVo.getActivityDefinitionId()) ||
                                taskAgentVo.getActivityDefinitionId().equals(pfActivityVo.getActivityDefinitionId())) {
                            if (taskAgentVo.getBeginTime() == null || taskAgentVo.getBeginTime().before(Calendar.getInstance().getTime())) {
                                if (taskAgentVo.getEndTime() == null || taskAgentVo.getEndTime().after(Calendar.getInstance().getTime())) {
                                    //判断是否为委托类型
                                    if (1 == taskAgentVo.getAgentType()) {
                                        trustAgentUserId = taskAgentVo.getUserId();
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank(trustAgentUserId)) {
                System.out.println("被委托人的userId：" + trustAgentUserId);
                user = userService.getUserVo(trustAgentUserId);
            }
            //---add 2018-10-08 判断该任务是否被委托

            if (user.getMobilePhone() != null) {
                try {
                    StringBuilder receiver = new StringBuilder(user.getUserName());
                    if(StringUtils.isNotBlank(user.getUserPost()))
                        receiver.append(user.getUserPost());

                    praseMap.put("sender",currUserName);
                    praseMap.put("receiver",receiver);
                    praseMap.put("activityName",pfActivityVo.getActivityName());
                    praseMap.put("workflowDefineName",pfWorkFlowDefineVo.getWorkflowName());
                    praseMap.put("overTime", CalendarUtil.sdf_China_Hour.format(task.getOverTime()));
                    String msgTemplate = null;
                    if(smsTemplate.containsKey(pfWorkFlowDefineVo.getWorkflowDefinitionId()+pfActivityVo.getActivityDefinitionId()))
                        msgTemplate = smsTemplate.get(pfWorkFlowDefineVo.getWorkflowDefinitionId()+pfActivityVo.getActivityDefinitionId());
                    else
                        msgTemplate = smsTemplate.get("default");

                    String tempSms = sub.replace(msgTemplate);
                    smsService.sendMsg("系统发送", user.getUserName(), user.getMobilePhone(), tempSms);
                } catch (Exception e) {
                    log.debug(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 通过TurnInfo处理url
     *
     * @param doc
     * @return
     */
    private Document httpFilterXml(Document doc, ActivityModel actModel) {
        if (StringUtils.isNotBlank(actModel.getTurnInfoUrl())) {
            HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            PostMethod postMethod = new PostMethod(actModel.getTurnInfoUrl());
            NameValuePair[] data = {
                    new NameValuePair("turnInfo", doc.asXML())
            };
            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod(postMethod);
            } catch (IOException e) {
                log.error("TurnInfo filter url request failer{}", e);
            }
            if (status == HttpStatus.SC_OK) {
                SAXReader reader = new SAXReader();
                try {
                    doc = reader.read(postMethod.getResponseBodyAsString());
                } catch (Exception e) {
                    log.error("TurnInfo filter url request success,prase failure{}", e);
                }
            } else {
                log.error("TurnInfo filter url request failer");
            }
        }
        return doc;
    }

    public boolean turnTask(String xml, String taskId, String userId) throws Exception {
             Document doc = DocumentHelper.parseText(xml);
            WorkFlowInfo info = getWorkFlowTurnInfo(userId, taskId);
            List<Node> activityList = doc.selectNodes("//Activity");
            List<String> activitys=new ArrayList<String>();
            for (Node node : activityList) {
                activitys.add(node.valueOf("@Id"));
            }
            //处理活动
            List<ActivityModel> lstActivityModel= info.getTransInfo().getTranActivitys();

            for (Iterator<ActivityModel> itModel = lstActivityModel.iterator();itModel.hasNext();){
                ActivityModel model=itModel.next();
                if (!activitys.contains(model.getDefineId())){
                    itModel.remove();
                }else{
                    //处理活动中的任务
                    List<PerformerTaskModel> lstPerformer= model.getPerformerModelList();
                    List<Node> lstUser = (List<Node>) doc.selectNodes("//Activity[@Id='"
                            + model.getDefineId() + "']/UserInfo");
                    List<String> userIds=new ArrayList<String>();
                    List<String> performerIds=new ArrayList<String>();   //转发任务中，人员的部门或角色ids
                    for (Node node : lstUser) {
                        if (node.valueOf("@RoleId") != null){
                            performerIds.add(node.valueOf("@RoleId"));
                            //如果id为空或者-1表示该角色下所有人
                            if (StringUtils.isBlank(node.valueOf("@Id")) || node.valueOf("@Id").equals("-1")) {
                                userIds.addAll(getUsersByRoleId(node.valueOf("@RoleId")));
                            }else{
                                String ids = node.valueOf("@Id");
                                if (!StringUtils.equalsIgnoreCase(ids,"nouser")){
                                    String[] idAry = StringUtils.split(ids,",");
                                    for (int i = 0; i < idAry.length; i++) {
                                        userIds.add(idAry[i].trim());
                                    }
                                }
                            }
                        }else{
                            //针对前台传递过来无效的用户信息进行过滤
                            if (StringUtils.isNotBlank(node.valueOf("@Id"))){
                                String ids = node.valueOf("@Id");
                                String[] idAry = StringUtils.split(ids,",");
                                for (int i = 0; i < idAry.length; i++) {
                                    userIds.add(idAry[i].trim());
                                }
                            }
                            //userIds.add(node.valueOf("@Id"));
                        }
                    }
                    List<String> userTmpList=new ArrayList<String>();
                    //过滤用户
                    if (userIds.size()>0){
                        //for(PerformerTaskModel taskModel:lstPerformer){
                        for (Iterator<PerformerTaskModel> itPerformer =lstPerformer.iterator();itPerformer.hasNext();){
                            PerformerTaskModel taskModel= itPerformer.next();
                            if (taskModel.getId()!=null && !performerIds.contains(taskModel.getId())){
                                itPerformer.remove();
                                continue;
                            }
                            for (Iterator<PfUserVo> it = taskModel.getUserList().iterator();it.hasNext();){
                                 PfUserVo vo = (PfUserVo)it.next();
                                 if (userTmpList.contains(vo.getUserId())){
                                     it.remove();
                                 }else{
                                     if (!userIds.contains(vo.getUserId())){
                                        //taskModel.getUserList().remove(vo);
                                        it.remove();
                                     }else{
                                         userTmpList.add(vo.getUserId());
                                     }
                                 }
                             }
                        }
                    }
                }
            }
            // 备注
            Node remarkNode = doc.selectSingleNode("//ReMark/text");
            if (remarkNode != null){
                if (!"".equals(remarkNode.getText().trim()))
                    info.getTransInfo().setRemark(remarkNode.getText());
            }
            //开始转发
            getWorkFlowCoreService().postWorkFlow(userId, taskId, info);

            if(Boolean.parseBoolean(doc.selectSingleNode("/Activitys").valueOf("@SendSMS"))){
                sendTaskSMS(info);
            }

        return false;
    }

    public void setSmsService(SysSmsService smsService) {
        this.smsService = smsService;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public void setSysActivityService(SysActivityService sysActivityService) {
        this.sysActivityService = sysActivityService;
    }

    public SysSubProcessService getSysSubProcessService() {
        return sysSubProcessService;
    }

    public void setSysSubProcessService(SysSubProcessService sysSubProcessService) {
        this.sysSubProcessService = sysSubProcessService;
    }

    public void setSmsTemplate(Map<String, String> smsTemplate) {
        this.smsTemplate = smsTemplate;
    }

    public List<WorkFlowBean> getOverWorkFlowBean() {
        return overWorkFlowBean;
    }

    public void setOverWorkFlowBean(List<WorkFlowBean> overWorkFlowBean) {
        this.overWorkFlowBean = overWorkFlowBean;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService sysWorkFlowDefineService) {
        this.sysWorkFlowDefineService = sysWorkFlowDefineService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void clearAll(){
        cacheManager.clearAll();
    }
}
