package com.gtis.plat.wf;

import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysWorkFlowInstanceExtDao;
import com.gtis.plat.form.FormSqlProcessor;
import com.gtis.plat.service.*;
import com.gtis.plat.wf.model.ActivityModel;
import org.apache.commons.lang.StringUtils;
import org.springframework.jms.core.JmsTemplate;

import javax.jms.Destination;
import java.util.List;

public abstract class WorkFlowBeanAbstract implements WorkFlowBean {
// ------------------------------ FIELDS ------------------------------
    public String platUrl;
    public SysUserService userService;
    SysTaskService taskService;
    FormSqlProcessor formSqlProcessor;

    protected SysWorkFlowDefineService workFlowDefineService;
    protected SysWorkFlowInstanceService worFlowInstanceService;
    protected SysWorkFlowInstanceRelService workFlowInstanceRelService;
    protected JmsTemplate jmsTemplate;
    protected Destination destination;

    protected SysWorkFlowInstanceExtDao workFlowInstanceExtDao;

// --------------------- GETTER / SETTER METHODS ---------------------


    public FormSqlProcessor getFormSqlProcessor() {
        return formSqlProcessor;
    }

    public void setFormSqlProcessor(FormSqlProcessor formSqlProcessor) {
        this.formSqlProcessor = formSqlProcessor;
    }

    public JmsTemplate getJmsTemplate() {
        return jmsTemplate;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public String getPlatUrl() {
        return platUrl;
    }

    public void setPlatUrl(String platUrl) {
        this.platUrl = platUrl;
    }

    public SysTaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysUserService getUserService() {
        return userService;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public SysWorkFlowInstanceService getWorFlowInstanceService() {
        return worFlowInstanceService;
    }

    public void setWorFlowInstanceService(
            SysWorkFlowInstanceService worFlowInstanceService) {
        this.worFlowInstanceService = worFlowInstanceService;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return workFlowDefineService;
    }

    public void setWorkFlowDefineService(
            SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public SysWorkFlowInstanceRelService getWorkFlowInstanceRelService() {
        return workFlowInstanceRelService;
    }

    public void setWorkFlowInstanceRelService(SysWorkFlowInstanceRelService workFlowInstanceRelService) {
        this.workFlowInstanceRelService = workFlowInstanceRelService;
    }

    /**
     * 在WorkflowBean中新增了一个方法，判断当前流程是否为四全服务模式下大流程
     * @param wiid 工作流Id
     * @return
     */
    public boolean isFullWorkflow(String wiid){
        String sqConfig = AppConfig.getProperty("useSq.enable");
        List workflowInstanceRelList =  this.getWorkFlowInstanceRelService().getWorkFlowRelList(wiid);
        if(StringUtils.isNotBlank(sqConfig)&&Boolean.parseBoolean(sqConfig)&&workflowInstanceRelList!=null&&workflowInstanceRelList.size()>0){
            return true;
        }else
            return false;
    }

    public SysWorkFlowInstanceExtDao getWorkFlowInstanceExtDao() {
        return workFlowInstanceExtDao;
    }

    public void setWorkFlowInstanceExtDao(SysWorkFlowInstanceExtDao workFlowInstanceExtDao) {
        this.workFlowInstanceExtDao = workFlowInstanceExtDao;
    }
}
