package com.gtis.plat.wf;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.impl.SysUserServiceImpl;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.util.ContainUtil;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**.
 * User: jibo
 * Date: 12-2-4
 * Time: 下午9:10
 */
public class UserUtil {

    static String  USERIDS_KEY="userIds";
    /**
     * 获取用户的userid，如果是管理员返回空
     * @return
     */
    public static String  getTaskUserIds(){
        return SessionUtil.getCurrentUserId().equals("0") ? null:SessionUtil.getCurrentUserIds();
    }

    /**
     * 将当前用户的userids，设置到hashmap中，同样管理设置空
     */
    public static void setTaskUserMapIds(Map mapParam){
        if (mapParam==null) mapParam=new HashMap<String,Object>();
        mapParam.put(USERIDS_KEY,getTaskUserIds());
    }

    /**
     * 获取当前人员的固定参数，作为url的解析，url中可以配置${username}来获取用户名
     * @param activityRoleList
     * @return
     */
    public static HashMap initCurUserUrlMap(List<String> activityRoleList){
        HashMap curUserParam = new HashMap();
        try {
            SysUserServiceImpl sysUserService=(SysUserServiceImpl)Container.getBean("SysUserServiceImpl");
            if (SessionUtil.getCurrentUser() != null){
                UserInfo userInfo = SessionUtil.getCurrentUser();
                PfUserVo pfUser = sysUserService.getUserVo(userInfo.getId());
                curUserParam.put("userid",pfUser.getUserId());
                curUserParam.put("username",pfUser.getUserName());
                curUserParam.put("loginname",pfUser.getLoginName());
                if (userInfo.getLstRole() != null && !userInfo.getLstRole().isEmpty()){
                    List<PfRoleVo> roles=SessionUtil.getCurrentUser().getLstRole();
                    String roleId = roles.get(0).getRoleId();
                    if (activityRoleList != null && activityRoleList.size() > 0){
                        for (PfRoleVo pfRoleVo:roles){
                            if (activityRoleList.contains(pfRoleVo.getRoleId())){
                                roleId=pfRoleVo.getRoleId();
                                break;
                            }
                        }
                    }

                    curUserParam.put("role",roleId);
                    curUserParam.put("roles",userInfo.getRoleIds());
                }

                if (userInfo.getLstOragn() != null && !userInfo.getLstOragn().isEmpty()){
                    curUserParam.put("organ",userInfo.getLstOragn().get(0).getOrganId());
                    curUserParam.put("xzqdm",userInfo.getLstOragn().get(0).getRegionCode());
                }
            }
        }catch (Exception ex){
        }
        return curUserParam;
    }

    public static String freemarkerProcess(Map input, String templateStr) {
        if (StringUtils.contains(templateStr,"${")){
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            String template = "content";
            stringLoader.putTemplate(template, templateStr);
            Configuration cfg = new Configuration();
            cfg.setTemplateLoader(stringLoader);
            try {
                Template templateCon = cfg.getTemplate(template);
                StringWriter writer = new StringWriter();
                templateCon.process(input, writer);
                return writer.toString();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (TemplateException e) {
                e.printStackTrace();
            }
        }
        return templateStr;
    }
}
