package com.gtis.plat.task;



import com.gtis.plat.dao.SysCalendarDAO;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 记录特殊工作日特殊,周六和周日的工作日，周一到周五的非工作日
 * 只记录年月日，格式：yyyy-MM-dd
 * User: jibo
 * Date: 14-8-26
 * Time: 上午1:57
 * To change this template use File | Settings | File Templates.
 */
public class SpecialWorkDayPack implements InitializingBean {
    static Logger logger = LoggerFactory.getLogger(SpecialWorkDayPack.class);

    private  static List<String> specialHolidays=new ArrayList<String>();
    private  static List<String> specialWorkdays=new ArrayList<String>();
    private static SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat simpleDateFullFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm");

    private static String WorkStartTime="08:30";
    //private static String WorkEndTime="17:30";


    private SysCalendarDAO calendarDAO;
    private SysWorkFlowInstanceDao workFlowInstanceDao;

    public void setCalendarDAO(SysCalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }

    public void setWorkFlowInstanceDao(SysWorkFlowInstanceDao workFlowInstanceDao) {
        this.workFlowInstanceDao = workFlowInstanceDao;
    }

    public void afterPropertiesSet() throws java.lang.Exception{
        init();
    }
    /**
     * 初始化，只取去年、今年和明年的数据,3年的数据
     */
    public void init(){
        List<String> specialHolidays=new ArrayList<String>();
        List<String> specialWorkdays=new ArrayList<String>();
        Calendar ca=Calendar.getInstance();
        int yearInt=Calendar.getInstance().get(Calendar.YEAR);
        //Date beginDate=ca.set(Calendar.ye);
        ca.set(Calendar.YEAR,yearInt-1);
        ca.set(Calendar.DAY_OF_YEAR, 1);//本年第一天
        Date beginDate=ca.getTime();
        ca.set(Calendar.YEAR,yearInt+2);
        ca.set(Calendar.DAY_OF_YEAR, 1);//本年第一天
        ca.add(Calendar.DAY_OF_YEAR, -1);
        Date endDate=ca.getTime();
        List<Map> specialDates=calendarDAO.getSpecialDateList(beginDate,endDate);
        for(Map sDate:specialDates){
            if (sDate.get("CAL_TYPE").equals("工作日"))
                specialWorkdays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
            else
                specialHolidays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
        }
    }

    /**
     * 自动计算工作日
     */
    public void CalWorkDayAutoTask() {
        Date endTime=  Calendar.getInstance().getTime();
        if (!IsHoliday(Calendar.getInstance().getTime())){
            logger.info("-------工作流开始计算工作日------");
            try{
            //工作流实例的计算日
            List<Map>  workFlowInstanceList= workFlowInstanceDao.getWorkFlowInstanceForHandlesDay();
            logger.info("-------活动工作实例共："+workFlowInstanceList.size()+"------");
            for(Map workFlowInstance:workFlowInstanceList){
                if (workFlowInstance.get("CREATE_TIME")!=null){
                     Date beginDate= (Date)workFlowInstance.get("CREATE_TIME");
                     if (beginDate.compareTo(endTime)<=0 && getDiffDay(beginDate,endTime)<365){
                        double days=calWorkDay(beginDate,endTime);
                        workFlowInstanceDao.updateWorkFlowHandleDayById(workFlowInstance.get("WORKFLOW_INSTANCE_ID").toString(),(int)Math.floor(days));
                     }
                }
            }
            //活动的工作日
            List<Map>  activityList= workFlowInstanceDao.getWorkFlowActivityForHandlesDay();
            logger.info("-------活动共："+activityList.size()+"------");
            for(Map workFlowInstance:activityList){
                if (workFlowInstance.get("BEGIN_TIME")!=null){
                    Date beginDate= (Date)workFlowInstance.get("BEGIN_TIME");
                    if (beginDate.compareTo(endTime)<=0 && getDiffDay(beginDate,endTime)<365){
                        double days=calWorkDay(beginDate,endTime);
                        workFlowInstanceDao.updateActivityHandleDayById(workFlowInstance.get("ACTIVITY_ID").toString(),(int)Math.floor(days));
                    }
                }
            }
            }catch (Exception ex){
                logger.error("--------工作日计算异常，请联系管理员-----------",ex);
            }
        }
    }

    public double calWorkDay(Date beginDate,Date endDate) throws Exception{
        //得到开始时间工作日的上班时间(如果开始时间是节假日)
        Date workBeginDate=getFirstWorkDate(beginDate);
        double day= getDiffDay(workBeginDate,endDate);
        Calendar ca=Calendar.getInstance();
        int hDays=getHolidays(workBeginDate,endDate);
        day=day- hDays;
        return (int)Math.floor(day);
    }

    public int getHolidays(Date beginDate,Date endDate) throws Exception{
        int day=0;
        Calendar ca=Calendar.getInstance();
        ca.setTime(getFirstWorkDate(beginDate));
        while(ca.getTime().compareTo(endDate)<=0){
            if (IsHoliday(ca.getTime()))
                day++;
            ca.add(Calendar.DAY_OF_YEAR,1);//把dateBegin加上1天然后重新赋值给date1
        }
        return day;
    }

    /**
     * 如果开始时间是非工作日，得到工作日的第一天的08：30
     * @param beginDate
     * @return
     * @throws Exception
     */
    public Date getFirstWorkDate(Date beginDate) throws Exception{
        Calendar ca=Calendar.getInstance();
        ca.setTime(beginDate);
        if (IsHoliday(beginDate)){
            ca.add(Calendar.DAY_OF_YEAR,1);
            while(IsHoliday(ca.getTime())){
                ca.add(Calendar.DAY_OF_YEAR,1);
            }
            ca.setTime(simpleDateFullFormat.parse(simpleDateFormat.format(ca.getTime()) + " " + WorkStartTime));
        }
        return ca.getTime();
    }

    /**
     * 判断是否非工作日(节假日)
     * @param bDate
     * @return
     */
    public boolean IsHoliday(Date bDate){
        Calendar ca=Calendar.getInstance();
        ca.setTime(bDate);
        String dateStr= simpleDateFormat.format(bDate);
        if (ca.get(Calendar.DAY_OF_WEEK)==1 || ca.get(Calendar.DAY_OF_WEEK)==7){
            return !specialWorkdays.contains(dateStr);
        }else{
            return specialHolidays.contains(dateStr);
        }
    }
    /**
     * 计算两个时间差多少天
     * @param beginDate
     * @param endDate
     * @return
     */
    private double getDiffDay(Date beginDate,Date endDate){
        long time=   endDate.getTime() -beginDate.getTime();
        return time*1.0/(1000*60*60*24);
    }

    public static void main(String[] arg) throws Exception{
        SpecialWorkDayPack ss=new SpecialWorkDayPack();
        SimpleDateFormat sf=new SimpleDateFormat("yyyy-MM-dd HH:mm");
        System.out.println(ss.calWorkDay(sf.parse("2014-08-08 23:33"), sf.parse("2014-08-17 12:01")));
        System.out.println(ss.calWorkDay(sf.parse("2014-08-09 10:33"), sf.parse("2014-08-16 12:01")));
        System.out.println(ss.calWorkDay(sf.parse("2014-08-10 09:33"), sf.parse("2014-08-16 12:01")));
    }
}

