package com.gtis.plat.service.impl.search;

import com.gtis.config.AppConfig;
import com.gtis.search.Business;
import com.gtis.search.Category;
import com.gtis.search.Index;
import com.gtis.search.IndexProvider;
import com.ibatis.sqlmap.client.SqlMapClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-11-27
 */
public class WfSearchIndexProviderImpl implements IndexProvider {
    private final Business business;

    private SqlMapClientTemplate sqlTemplate;

    @Autowired
    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        sqlTemplate = new SqlMapClientTemplate(sqlMapClient);
    }

    public WfSearchIndexProviderImpl() {
        business = new Business();
        business.setId("wf");
        business.setName("工作流");
        business.setLastModified(0l);
        Category task = new Category();
        task.setBusinessId(business.getId());
        task.setId("getTaskList");
        task.setName("待办任务");
        task.setBusinessId(business.getId());
        Category taskover = new Category();
        taskover.setBusinessId(business.getId());

        String canQueryTransUsers = AppConfig.getProperty("platform.taskoverlist.query.transusers");
        String querySql = "getTaskOverList";
        if (StringUtils.equalsIgnoreCase("true",canQueryTransUsers)){
            querySql = "getTaskOverList_TransUsers";
        }
        taskover.setId(querySql);
        taskover.setName("已办任务");
        Category project = new Category();
        project.setBusinessId(business.getId());
        project.setId("getProjectList");
        project.setName("项目列表");
        business.getCategories().add(task);
        business.getCategories().add(taskover);
        business.getCategories().add(project);
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public List<Business> getBusinesses() {
        return Collections.singletonList(business);
    }

    @Override
    public int getTotalCount(String categoryId) {
        return Integer.parseInt(sqlTemplate.queryForObject(categoryId + "_COUNT").toString());
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<Index> getIndexes(String categoryId, int start, int size) {
        List<Index> list = new ArrayList<Index>();
        for (Object entity : sqlTemplate.queryForList(categoryId, start, size)) {
            list.add(toIndex((Map) entity, categoryId));
        }
        return list;
    }

    @Override
    @SuppressWarnings("unchecked")
    public Index getIndex(String categoryId, String id) {
        return toIndex((Map) sqlTemplate.queryForObject(categoryId, Collections.singletonMap("ID", id)), categoryId);
    }

    public Index toIndex(Map<String, Serializable> entity, String categoryId) {
        Index index = new Index();
        index.setBusinessId("wf");
        index.setCategoryId(categoryId);
        //index.setTitle(getStr(entity, "WORKFLOW_INSTANCE_NAME"));
        index.setPublic(false);
        if ("getTaskList".equals(categoryId)) {
            index.setId("t-" + entity.get("ASSIGNMENT_ID"));
        } else if ("getTaskOverList".equals(categoryId) || "getTaskOverList_TransUsers".equals(categoryId)) {
            index.setId("to-" + entity.get("ASSIGNMENT_ID"));
        } else if ("getProjectList".equals(categoryId)) {
            index.setId("p-" + entity.get("WORKFLOW_INSTANCE_ID"));
        }
        addFields(entity, index,
                "WORKFLOW_STATE",
                "PRIORITY",
                "WORKFLOW_INSTANCE_NAME",
                "WORKFLOW_DEFINITION_ID",
                "WORKFLOW_NAME",
                "ASSIGNMENT_ID",
                "ACTIVITY_NAME",
                "BEGIN_TIME",
                "FINISH_TIME",
                "CREATE_TIME",
                "CREATE_USERNAME",
                "CDAY",
                "IDAY",
                "REMARK",
                "ACTIVITY_ID",
                "WORKFLOW_INSTANCE_ID",
                "BUSINESS_ID",
                "USER_ID",
                "IS_RISK",
                "ISBACK",
                "AREMARK",
                "MONITOR_ID",
                "PROID",
                "regionCode"
        );
        return index;
    }

    private static void addFields(Map<String, Serializable> entity, Index index, String... keys) {
        for (String key : keys) {
            Serializable value = entity.get(key);
            if (value != null) {
                if (value instanceof BigDecimal) {
                    value = ((Number) value).intValue();
                }
                index.addSearchableField(key, value);
            }
        }
    }
}
