package com.gtis.plat.service.impl;

import com.gtis.plat.vo.PfSmsVo;
import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/**
 * @description 中科软短信服务
 */
public class ZkrSmsServiceImpl extends SysSmsServiceImpl {
    private String sessionID;
    private String events;
    private String smsUrl;

    /**
     * @param sms 短信对象
     * @return
     * @throws Exception
     */

    public String sendMsg(PfSmsVo sms) throws Exception {
    	String msg = "";
        if (sms != null && StringUtils.isNotBlank(smsUrl)) {
            //获取配置
            if (StringUtils.isNotBlank(sms.getMobileNo())){
            	msg = sendSms(sms.getMobileNo(),sms.getContent());
            }
        }
        return msg;
    }
    public String sendMsg(String sender,String receive,String phone,String content) throws Exception{
    	String msg = "";
    	if (StringUtils.isNotBlank(phone) && StringUtils.isNotBlank(content) && StringUtils.isNotBlank(smsUrl)){
        	msg = sendSms(phone,content);
        }
        return msg;
    }
    
    /**
     * @param phoneNum 手机号
     * @param content  内容
     * @return
     * @description 发送短信
     */
    public String sendSms(String phoneNum, String content) throws Exception {
    	String smsResult = "error";
        String smsDescription="短信发送失败！";
        if (StringUtils.isNotBlank(phoneNum)) {
            try {
                HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
                connectionManager.getParams().setConnectionTimeout(30000);
                connectionManager.getParams().setSoTimeout(30000);
                HttpClient httpClient = new HttpClient(connectionManager);
                if (StringUtils.isNotBlank(smsUrl)) {
                    try {
                        PostMethod postMethod = new PostMethod(smsUrl);
                        postMethod.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "UTF-8");
                        NameValuePair[] postData = new NameValuePair[7];
                        postData[0] = new NameValuePair("SessionID", sessionID);
                        postData[1] = new NameValuePair("events", events);
                        postData[2] = new NameValuePair("p0", "0");
                        postData[3] = new NameValuePair("p1", phoneNum);
                        postData[4] = new NameValuePair("p2", content);
                        postData[5] = new NameValuePair("p3", "");
                        postData[6] = new NameValuePair("p4", "");
                        postMethod.addParameters(postData);

                        httpClient.executeMethod(postMethod);

                        int status = httpClient.executeMethod(postMethod);
                        if (status == HttpStatus.SC_OK){
                            String result = postMethod.getResponseBodyAsString();
                            System.out.println("请求返回结果"+result);
                            if (result != null){
                                if (result.equalsIgnoreCase("1")){
                                    smsResult = "ok";
                                    smsDescription = "短信发送成功！";
                                }
                            }
                        }
                        postMethod.releaseConnection();
                    } catch (SocketTimeoutException eTimeOut) {
                        eTimeOut.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return smsResult;
    }
    
    /** 
     * 将url参数转换成map 
     * @param param aa=11&bb=22&cc=33 
     * @return 
     */  
    public static Map<String, String> getUrlParams(String param) {  
        Map<String, String> map = new HashMap<String, String>(0);  
        if (StringUtils.isBlank(param)) {  
            return map;  
        }  
        String[] params = param.split("&");  
        for (int i = 0; i < params.length; i++) {  
            String[] p = params[i].split("=");  
            if (p.length == 2) {  
                map.put(p[0], p[1]);  
            }  
        }  
        return map;  
    }

    public String getSessionID() {
        return sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getEvents() {
        return events;
    }

    public void setEvents(String events) {
        this.events = events;
    }

    public String getSmsUrl() {
        return smsUrl;
    }

    public void setSmsUrl(String smsUrl) {
        this.smsUrl = smsUrl;
    }
}
