package com.gtis.plat.service.impl;

import com.gtis.common.util.Md5Util;
import com.gtis.plat.vo.PfSmsVo;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.*;

/**
 * @description 云信通短信服务
 */
public class YxtSmsServiceImpl extends SysSmsServiceImpl {
    private String username;
    private String password;
    private String smsUrl;
    
    public String sendMsg(PfSmsVo sms) throws Exception {
    	String msg = "";
        if (sms != null) {
            //获取配置
            if (StringUtils.isNotBlank(sms.getMobileNo())){
            	msg = sendSms(sms.getMobileNo(),sms.getContent());
            }
        }
        return msg;
    }
    public String sendMsg(String sender,String receive,String phone,String content) throws Exception{
    	String msg = "";
    	if (StringUtils.isNotBlank(phone) && StringUtils.isNotBlank(content)){
        	msg = sendSms(phone,content);
        }
        return msg;
    }
    
    /**
     * @param phoneNum 手机号
     * @param content  内容
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 发送短信
     */
    public String sendSms(String phoneNum, String content) throws Exception {
    	String smsResult = "error";
        String smsDescription="短信发送失败！";
        try {
        	HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
            connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
            connectionManager.getParams().setConnectionTimeout(30000);
            connectionManager.getParams().setSoTimeout(30000);
            HttpClient httpClient = new HttpClient(connectionManager);
            StringBuilder smsUrlBuilder = new StringBuilder(smsUrl);
            smsUrlBuilder.append("?userId=");
            smsUrlBuilder.append(username);
            smsUrlBuilder.append("&password=");
            smsUrlBuilder.append(Md5Util.Build(password));
            smsUrlBuilder.append("&mobile=");
            smsUrlBuilder.append(phoneNum);
            smsUrlBuilder.append("&content=");
            smsUrlBuilder.append(URLEncoder.encode(content, "UTF-8"));
            System.out.println("test1===>"+smsUrlBuilder);
            PostMethod postMethod = new PostMethod(smsUrlBuilder.toString());
            postMethod.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "UTF-8");

            httpClient.executeMethod(postMethod);
            String info = postMethod.getResponseBodyAsString();
            System.out.println("请求成功！");
            if (StringUtils.isNotBlank(info)) {
            	System.out.println("返回内容："+info);
            	Map<String, String> map = getUrlParams(info);
            	if (map.containsKey("rspCode") && (StringUtils.equals(map.get("rspCode"), "0") || StringUtils.equalsIgnoreCase(map.get("rspCode"), "DELIVRD"))) {
            		smsResult = "ok";
				}
                smsDescription = map.get("rspDesc");
            }
            postMethod.releaseConnection();
        } catch (SocketTimeoutException eTimeOut) {
            eTimeOut.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        } catch (Exception e) {
            e.printStackTrace();
        }
        return smsResult;
    }
    
    /** 
     * 将url参数转换成map 
     * @param param aa=11&bb=22&cc=33 
     * @return 
     */  
    public static Map<String, String> getUrlParams(String param) {  
        Map<String, String> map = new HashMap<String, String>(0);  
        if (StringUtils.isBlank(param)) {  
            return map;  
        }  
        String[] params = param.split("&");  
        for (int i = 0; i < params.length; i++) {  
            String[] p = params[i].split("=");  
            if (p.length == 2) {  
                map.put(p[0], p[1]);  
            }  
        }  
        return map;  
    }  

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSmsUrl() {
        return smsUrl;
    }

    public void setSmsUrl(String smsUrl) {
        this.smsUrl = smsUrl;
    }
}
