package com.gtis.plat.service.impl;

import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysSmsDao;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.vo.PfSmsVo;

public class YantaiSysSmsServiceImpl implements SysSmsService {
    private SysSmsDao smsDAO;
	private String smsUrl;

	/**
     * 发送消息
     * @param sender 发送人的签名
     * @param phone 电话号码
     * @param content 短消息的内容
     * @return
     */
	@Override
	public String sendMsg(String sender, String receive, String phone, String content) throws Exception {
		PfSmsVo sms = new PfSmsVo();
        sms.setSender(sender);
        sms.setReceive(receive);
        sms.setMobileNo(phone);
        sms.setContent(content);
        sms.setSendDate(new Date());
        
        return sendMsg(sms);
	}

    /**
     * 消息状态查询
     * @param msgNo 消息编号
     * @return 默认 -1
     */
	@Override
	public int msgState(String msgNo) throws Exception {
		if(StringUtils.isNotBlank(msgNo)){
            return Integer.parseInt(smsDAO.msgState(msgNo));
        }
        return -1;
	}

    /**
     * 发送消息
     * @param sms 短信对象
     * @return 消息发送的状态
     * @throws Exception
     */
	@Override
	public String sendMsg(PfSmsVo sms) throws Exception {
		String msg = "发送失败";
		if (StringUtils.isNotBlank(smsUrl)) {
			if (StringUtils.isNotBlank(sms.getMobileNo())) {
				if (SpSysSmsServiceImpl.isMobileNum(sms.getMobileNo())) {
					String tmpUrl = smsUrl + "?phone=" + sms.getMobileNo() + "&message=" + URLEncoder.encode(sms.getContent(), "UTF-8");
					HttpClient client = new HttpClient();
	    			GetMethod method = new GetMethod(tmpUrl);
	    			client.executeMethod(method);
	    			//打印服务器返回的状态
	    			System.out.println("服务器查询返回的状态" + method.getStatusLine());
	    			//打印服务器返回的数据
	    			String returnJson = method.getResponseBodyAsString();
	    			System.out.println(returnJson);
	    			if (StringUtils.isNotBlank(returnJson)) {
	    				Map resultMap = JSON.parseObject(returnJson, Map.class);
	    				msg = MapUtils.getString(resultMap, "msg", msg);
	    				insertSmsLog(sms);
	    			}
				} else {
					msg = "手机号码不正确，请核实";
				}
			} else {
				msg = "手机号码为空，请核实";
			}
		} else {
			msg = "短信接口地址为空，请核实";
		}
        return msg;
	}

    /**
     * 插入短息
     * @param sms
     */
	@Override
	public void insertSmsLog(PfSmsVo sms) {
		if (StringUtils.isBlank(sms.getSmsId())) {
			sms.setSmsId(UUIDGenerator.generate());
		}
		smsDAO.insertSmsLog(sms);
	}

	public SysSmsDao getSmsDAO() {
		return smsDAO;
	}

	public void setSmsDAO(SysSmsDao smsDAO) {
		this.smsDAO = smsDAO;
	}

	public String getSmsUrl() {
		return smsUrl;
	}

	public void setSmsUrl(String smsUrl) {
		this.smsUrl = smsUrl;
	}

}
