package com.gtis.plat.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysSmsDao;
import com.gtis.plat.dao.SysSmsGatewayDao;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.vo.PfSmsVo;
import com.linkage.netmsg.NetMsgclient;
import com.linkage.netmsg.server.AnswerBean;
import com.linkage.netmsg.server.ReceiveMsg;
import com.linkage.netmsg.server.ReturnMsgBean;
import com.linkage.netmsg.server.UpMsgBean;
import org.apache.commons.lang.StringUtils;

import java.io.IOException;
import java.util.Calendar;

/**
 * 中国电信企信通短信服务
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/11/11
 */
public class TeleComSysSmsServiceImpl implements SysSmsService{
    private String hostIp;
    private int hostPort;
    private String userName;
    private String password;
    private NetMsgclient netMsgclient;
    private SysSmsDao smsDAO;

    public boolean initNetMsgClient(){
        netMsgclient = new NetMsgclient();
        ReceiveMsg receiveMsg = new TeleComReceiveMsg();
        netMsgclient = netMsgclient.initParameters(hostIp, hostPort, userName, password, receiveMsg);
        try {
            return netMsgclient.anthenMsg(netMsgclient);
        } catch (IOException e) {
            destroyNetMsgClient();
            e.printStackTrace();
        }
        return false;
    }

    public void destroyNetMsgClient(){
        if(netMsgclient!=null)
            netMsgclient.closeConn();
    }

    @Override
    public String sendMsg(String sender, String receive, String phone, String content) throws Exception {
        PfSmsVo pfSmsVo = new PfSmsVo();
        pfSmsVo.setSmsId(UUIDGenerator.generate());
        pfSmsVo.setContent(content);
        pfSmsVo.setSender(sender);
        pfSmsVo.setReceive(receive);
        pfSmsVo.setMobileNo(phone);
        pfSmsVo.setSendDate(Calendar.getInstance().getTime());
        return sendMsg(pfSmsVo);
    }

    @Override
    public int msgState(String msgNo) throws Exception {
        return 0;
    }

    @Override
    public String sendMsg(PfSmsVo sms) throws Exception {
        String result = netMsgclient.sendMsg(netMsgclient, 0, sms.getMobileNo(), sms.getContent(), 0);
        sms.setSendDate(Calendar.getInstance().getTime());
        if(StringUtils.isBlank(sms.getSmsId()))
            sms.setSmsId(UUIDGenerator.generate());
        insertSmsLog(sms);
        return result;
    }

    @Override
    public void insertSmsLog(PfSmsVo sms) {
        smsDAO.insertSmsLog(sms);
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }


    public class TeleComReceiveMsg extends ReceiveMsg
    {
        public void getAnswer(AnswerBean answerBean)
        {
            super.getAnswer(answerBean);
        }

        public void getUpMsg(UpMsgBean upMsgBean)
        {
            super.getUpMsg(upMsgBean);
        }

        public void getReturnMsg(ReturnMsgBean returnMsgBean)
        {
            super.getReturnMsg(returnMsgBean);
        }
    }


    public SysSmsDao getSmsDAO() {
        return smsDAO;
    }

    public void setSmsDAO(SysSmsDao smsDAO) {
        this.smsDAO = smsDAO;
    }
}
