package com.gtis.plat.service.impl;

import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.wf.WorkFlowXml;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

/**
 * 工作流定义类
 * 缓存名：WorkFlowDefineCache
 */
public class SysWorkFlowDefineServiceImpl implements SysWorkFlowDefineService {

	private SysWorkFlowDefineDao workFlowDefineDao;


	
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.gtis.plat.service.SysWorkFlowDefineService#getBusinessList()
	 */
    @Cacheable(value="WorkFlowDefineCache",key="'BusinessList'")
	public List<PfBusinessVo> getBusinessList() {
		return workFlowDefineDao.getBusinessList();
	}

	public List<PfBusinessVo> getBusinessListByUserAndParam(HashMap param){
		return workFlowDefineDao.getBusinessListByUserAndParam(param);
	}

    public List<PfBusinessVo> getBusinessSimpleList(){
        return new ArrayList(workFlowDefineDao.getBusinessSimpleList());
    }
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getBusiness(java.lang.
	 * String)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#bId+'Business'")
	public PfBusinessVo getBusiness(String bId) {
		return workFlowDefineDao.getBusiness(bId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefineByBusiness
	 * (java.lang.String)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#bId+'WorkFlowDefineListBybId'")
	public List<PfWorkFlowDefineVo> getWorkFlowDefineByBusiness(String bId) {
		return workFlowDefineDao.getWorkFlowDefineByBusiness(bId);
	}

	public List<PfWorkFlowDefineVo> getWorkFlowDefineByUserAndParam(HashMap param){
		return workFlowDefineDao.getWorkFlowDefineByUserAndParam(param);
	}

	public List<PfWorkFlowDefineVo> getWorkFlowDefineByParam(HashMap param){
		return workFlowDefineDao.getWorkFlowDefineByParam(param);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefineList()
	 */

	public List<PfWorkFlowDefineVo> getWorkFlowDefineList() {
		return new ArrayList(workFlowDefineDao.getWorkFlowDefineList());
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefine(java
	 * .lang.String)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#workDefineId+'WorkFlowDefineById'")
	public PfWorkFlowDefineVo getWorkFlowDefine(String workDefineId) {
		return workFlowDefineDao.getWorkFlowDefine(workDefineId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefineListByRole
	 * (java.lang.String, java.lang.String, java.lang.String)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#roleIds+#resourceId+#bId+'WorkFlowDefineByRole'")
	public List<PfWorkFlowDefineVo> getWorkFlowDefineListByRole(String roleIds,
			String resourceId, String bId) {
		return workFlowDefineDao.getWorkFlowDefineListByRole(roleIds,
				resourceId, bId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefineDao()
	 */
	public SysWorkFlowDefineDao getWorkFlowDefineDao() {
		return workFlowDefineDao;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#setWorkFlowDefineDao(com
	 * .gtis.plat.dao.SysWorkFlowDefineDao)
	 */

	public void setWorkFlowDefineDao(SysWorkFlowDefineDao workFlowDefineDao) {
		this.workFlowDefineDao = workFlowDefineDao;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefineXml(java
	 * .lang.String)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#workDefineId+'WorkFlowDefineXmlById'")
	public String getWorkFlowDefineXml(String workDefineId) {
		return workFlowDefineDao.getWorkFlowDefineXml(workDefineId);
	}

    @Cacheable(value="WorkFlowDefineCache",key="#workDefineId+'WorkFlowDefineLocation'")
    public String getWorkFlowDefineLocation(String workDefineId) {
        return workFlowDefineDao.getWorkFlowDefineLocation(workDefineId);
    }

	@Cacheable(value="WorkFlowInstanceCache",key="#workInstanceId+'WorkFlowInstanceLocation'")
	public String getWorkFlowInstanceLocation(String workInstanceId) {
		return workFlowDefineDao.getWorkFlowInstanceLocation(workInstanceId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefineXmlModel
	 * (com.gtis.plat.vo.PfWorkFlowDefineVo)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#defineVo.workflowDefinitionId+'WorkFlowDefineXmlById'")
	public String getWorkFlowDefineXml(PfWorkFlowDefineVo defineVo) {
		String instanceXml = getWorkFlowDefineXml(defineVo
				.getWorkflowDefinitionId());
		return instanceXml;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowDefineEventXml
	 * (com.gtis.plat.vo.PfWorkFlowDefineVo)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#defineVo.workflowDefinitionId+'WorkFlowDefineEventById'")
	public String getWorkFlowDefineEventXml(PfWorkFlowDefineVo defineVo) {
		if (defineVo.getEventShell() == null) {
			String xml = workFlowDefineDao.getWorkFlowDefineEventXml(defineVo.getWorkflowDefinitionId());
			defineVo.setEventShell(xml);
		}
		return defineVo.getEventShell();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowImage(java.
	 * lang.String)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#workDefineId+'WorkFlowImage'")
	public PfWorkFlowDefineVo getWorkFlowImage(String workDefineId) {
		return workFlowDefineDao.getWorkFlowImage(workDefineId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.gtis.plat.service.SysWorkFlowDefineService#getWorkFlowByDefinitionNo
	 * (java.lang.String)
	 */
    @Cacheable(value="WorkFlowDefineCache",key="#definitionNo+'WorkFlowByDefinitionByNo'")
	public PfWorkFlowDefineVo getWorkFlowByDefinitionNo(String definitionNo) {
		return workFlowDefineDao.getWorkFlowByDefinitionNo(definitionNo);
	}

	/**
	 * 根据流程转发顺序获取活动列表
	 * 
	 * @param workDefineId
	 * @return
	 */
//	public List<String> getActivitiesListByTransOrder(String workDefineId) {
//		List<String> activityList = new Vector<String>();
//
//		String instanceXml = workFlowDefineDao
//				.getWorkFlowDefineXml(workDefineId);
//		if (instanceXml == null)
//			return activityList;
//		WorkFlowXml xmlModel = new WorkFlowXml(instanceXml);
//		List<String[]> transitionsList = xmlModel.getTransitionList();
//
//		HashMap<String, String> parentMap = new HashMap<String, String>();
//
//		HashMap<String, List<String>> reverseRelMap = new HashMap<String, List<String>>();
//		HashMap<String, List<String>> toActivityMap = new HashMap<String, List<String>>();
//
//		for (String[] tempTrans : transitionsList) {
//			String fromActivityId = tempTrans[1];
//			String toActivityId = tempTrans[2];
//			List<String> toElementList = toActivityMap.get(fromActivityId);
//			if (toElementList == null) {
//				toElementList = new Vector<String>();
//				toActivityMap.put(fromActivityId, toElementList);
//			}
//			toElementList.add(toActivityId);// 把ToActivityId放入到List中
//
//			List<String> fromElementList = reverseRelMap.get(toActivityId);
//			if (fromElementList == null) {
//				fromElementList = new Vector<String>();
//				reverseRelMap.put(toActivityId, fromElementList);
//			}
//			fromElementList.add(fromActivityId);// 把fromActivityId放入到List中
//
//			if (parentMap.get(fromActivityId) == null) {
//				parentMap.put(fromActivityId, "no");
//			}
//
//			if (parentMap.get(toActivityId) == null
//					|| !parentMap.get(toActivityId).equalsIgnoreCase("yes")) {
//				parentMap.put(toActivityId, "yes");
//			}
//		}
//
//		String beginActivityId = "";
//		Iterator iter = parentMap.keySet().iterator();
//		while (iter.hasNext()) {
//			String tempKeyId = (String) iter.next();
//			if (parentMap.get(tempKeyId).equalsIgnoreCase("no")) {
//				beginActivityId = tempKeyId;
//			}
//		}
//		if (beginActivityId.length() == 0) {
//			return activityList;
//		}
//
//		HashMap<String, String> finishedMap = new HashMap<String, String>();
//		buildActivitySequence(beginActivityId, toActivityMap, reverseRelMap,
//				finishedMap, activityList);
//
//		return activityList;
//
//	}


    /**
     * 递归调用函数，按照转发顺序生成对应的活动列表
     * @param fromActivityId
     * @param toActivityMap
     * @param reverseRelMap
     * @param finishedMap
     * @param activityList
     */
//	private static void buildActivitySequence(String fromActivityId,
//			HashMap<String, List<String>> toActivityMap,
//			HashMap<String, List<String>> reverseRelMap,
//			HashMap<String, String> finishedMap, List<String> activityList) {
//		Log log = LogFactory.getLog("SysWorkFlowDefineServiceImpl");
//		log.info("fromActivityId=" + fromActivityId);
//		List toActivityIdList = (List) toActivityMap.get(fromActivityId);
//
//		if (toActivityIdList == null) {
//			log.info("stdProcessID=" + fromActivityId + "对应的列表为空ID为空");
//			toActivityIdList = new Vector();
//		}
//		if (finishedMap.get(fromActivityId) == null) {
//			finishedMap.put(fromActivityId, fromActivityId);
//			activityList.add(fromActivityId);
//		}
//		for (int i = 0; i < toActivityIdList.size(); i++) {
//			String toActivityId = (String) toActivityIdList.get(i);
//			log.info("----toActivityId=" + toActivityId);
//			if (finishedMap.get(toActivityId) == null) {
//				log.info("finishedMap.get(dtlID) == null");
//
//				List fromActivityIDList = (List) reverseRelMap
//						.get(toActivityId);
//				if (fromActivityIDList != null) {
//					log.info("|||||||fromActivityIDList.size()="
//							+ fromActivityIDList.size());
//					for (int j = 0; j < fromActivityIDList.size(); j++) {
//						String tempFromID = (String) fromActivityIDList.get(j);
//						log.info("tempFromID = " + tempFromID);
//						if (!finishedMap.containsKey(tempFromID)) {
//							log.info("add tempFromID ....................");
//							handleParentActivityTree(tempFromID, toActivityMap,
//									reverseRelMap, finishedMap, activityList);
//						}
//					}
//				}
//
//				if (finishedMap.get(toActivityId) == null) {
//					activityList.add(toActivityId);
//					finishedMap.put(toActivityId, toActivityId);
//
//				}
//			} else {
//				log.info("指定的toActivityId已经被处理");
//				continue;
//			}
//			log.info("activityList=" + activityList);
//			buildActivitySequence(toActivityId, toActivityMap, reverseRelMap,
//					finishedMap, activityList);
//		}
//		log.info("++++++++++++handleActivityTree end");
//	}

//	private static void handleParentActivityTree(String stdProcessID,
//			HashMap<String, List<String>> toActivityMap,
//			HashMap<String, List<String>> reverseRelMap,
//			HashMap<String, String> finishedMap, List<String> activityList) {
//
//		if (finishedMap.get(stdProcessID) == null) {
//			List parentList = (List) reverseRelMap.get(stdProcessID);
//			for (int i = 0; i < parentList.size(); i++) {
//				String tempParentId = (String) parentList.get(i);
//				handleParentActivityTree(tempParentId, toActivityMap,
//						reverseRelMap, finishedMap, activityList);
//			}
//			finishedMap.put(stdProcessID, stdProcessID);
//			activityList.add(stdProcessID);
//		}
//	}

	/**
	 * 获得需要监察的项目定义列表
	 * @return
	 */
    @Cacheable(value="WorkFlowDefineCache",key="'AllECWorkFlowDefineList'")
	public List<PfWorkFlowDefineVo> getECWorkFlowDefineList(){
		return workFlowDefineDao.getECWorkFlowDefineList();
	}
}
