package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysSmsDao;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.vo.PfSmsVo;
import org.apache.commons.lang.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * @(#)SysMsgServiceImpl.java 2010-4-6 1:03:52
 * Copy Right Information	: 南京国图
 * Project 					: 短信发送服务实现
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class SysSmsServiceImpl implements SysSmsService {
    /** 持久层服务 */
    private SysSmsDao smsDAO;
    
    /**
     * 发送消息
     * @param sender 发送人的签名
     * @param phone 电话号码
     * @param content 短消息的内容
     * @return
     */
    public String sendMsg(String sender,String receive,String phone,String content) throws Exception{
        PfSmsVo sms = new PfSmsVo();
        sms.setSender(sender);
        sms.setReceive(receive);
        sms.setMobileNo(phone);
        sms.setContent(content);
        sms.setSendDate(new Date());
        
        return sendMsg(sms);
    }

    /**
     * 消息状态查询
     * @param msgNo 消息编号
     * @return 默认 -1
     */
    public int msgState(String msgNo) throws Exception{
        if(StringUtils.isNotBlank(msgNo)){
            return Integer.parseInt(smsDAO.msgState(msgNo));
        }
        return -1;
    }

    /**
     * 发送消息
     * @param sms 短信对象
     * @return 消息发送的状态
     * @throws Exception
     */
    public String sendMsg(PfSmsVo sms) throws Exception {
        String result = smsDAO.insertSms(sms);
        smsDAO.insertSmsLog(sms);
        return result;
    }
    
    /**
     * 插入短息
     * @param sms
     */
    public void insertSmsLog(PfSmsVo sms) {
        smsDAO.insertSmsLog(sms);
    }

    /**
     * 返回短信列表
     * @return
     */
    public List<PfSmsVo> getSmsList() {
        return smsDAO.getSmsList();
    }

    public void setSmsDAO(SysSmsDao smsDAO) {
        this.smsDAO = smsDAO;
    }
}
