package com.gtis.plat.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysSignDAO;
import com.gtis.plat.dao.SysUserDAO;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.spring.Container;
import com.gtis.util.ImageUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.sign.SignUitl;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.transaction.annotation.Transactional;

import javax.imageio.ImageIO;
import javax.sql.DataSource;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SysSignServiceImpl implements SysSignService {
	private SysSignDAO signDAO;
    private SysUserDAO userDAO;
    private static String USER_AUTOSIGN_TYPE="1";
    private static String USER_CUSTOM_SIGN_TYPE="0";

    public void setUserDAO(SysUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setSignDAO(SysSignDAO signDAO) {
        this.signDAO = signDAO;
    }

    public List<PfSignVo> getSignList(String signKey, String proId) {
        return signDAO.getSignList(null,signKey,null,null,proId,null);
    }

    public List<PfSignVo> getSignListByUserId(String signKey,String proId,String userId){
        return signDAO.getSignList(null, signKey, null, null, proId, userId);
    }

    public List<PfSignVo> getSignListOrderfield(HashMap map) {
        return signDAO.getSignListOrderfield(map);
    }

    public PfSignVo getSign(String signId) {
        return signDAO.getSignNoImage(signId);
    }

    public PfSignVo getSignImage(String signId) {
        PfSignVo signVo=this.getSign(signId);
        if (signVo!=null){
            if (USER_AUTOSIGN_TYPE.equals(signVo.getSignType())){
                return signDAO.getUserSignImage(signId);
            }else{
                return signDAO.getSignImage(signId);
            }
        }else{
            return  null;
        }
    }

    public boolean insertAutoSign(PfSignVo signVo){
        signVo=this.CheckSignVo(signVo);
        signVo.setSignType(USER_AUTOSIGN_TYPE);
        signDAO.insertSign(signVo);

        String accrodJob = AppConfig.getProperty("platform.user.accrod.job");
        if (StringUtils.isNotBlank(accrodJob) && StringUtils.equalsIgnoreCase("true",accrodJob)){
            signVo.setSignType(USER_CUSTOM_SIGN_TYPE);
            if (StringUtils.isNotBlank(signVo.getUserId())){
                signDAO.updateSignPicByUser(signVo);
            }
        }
        return true;
    }

    @Transactional
    public boolean updateAutoSign(PfSignVo signVo){
        signVo=this.CheckSignVo(signVo);
        signVo.setSignType(USER_AUTOSIGN_TYPE);
        signDAO.updateSign(signVo);
        signDAO.updateSignNullPic(signVo.getSignId());
        String accrodJob = AppConfig.getProperty("platform.user.accrod.job");
        if (StringUtils.isNotBlank(accrodJob) && StringUtils.equalsIgnoreCase("true",accrodJob)){
            signVo.setSignType(USER_CUSTOM_SIGN_TYPE);
            if (StringUtils.isNotBlank(signVo.getUserId())){
                signDAO.updateSignPicByUser(signVo);
            }
        }
        return true;
    }

    public boolean updateSign(PfSignVo signVo) {
        signVo=this.CheckSignVo(signVo);
        signDAO.updateSign(signVo);
        return true;
    }

    public boolean deleteSign(String signId){
        signDAO.deleteSign(signId);
        return true;    
    }

    @Transactional
    public String AddCustomSign(String userId,String proId,String signKey,String imgStr){
        PfSignVo signVo =new PfSignVo();
        signVo.setProId(proId);
        signVo.setUserId(userId);
        signVo.setSignType(USER_CUSTOM_SIGN_TYPE);
        signVo.setSignKey(signKey);
        signVo=this.CheckSignVo(signVo);

        signVo=CheckSignVo(signVo);
        signDAO.insertSign(signVo);

        UpdateCustomSignPic(signVo.getSignId(),imgStr);
        return  signVo.getSignId();
    }


    @Transactional
    public String addCustomSign(PfSignVo pfSignVo,String imgStr){
        pfSignVo.setSignType(USER_CUSTOM_SIGN_TYPE);
        pfSignVo=CheckSignVo(pfSignVo);
        signDAO.insertSign(pfSignVo);
        UpdateCustomSignPic(pfSignVo.getSignId(), imgStr);
        return  pfSignVo.getSignId();
    }

    public boolean UpdateCustomSignPic(String signId,String imgStr){
        signDAO.updateSignEmptyPic(signId);
        this.UpdateSignPic(signId,imgStr);
        return true;
    }



    private PfSignVo CheckSignVo(PfSignVo signVo ){
        if (signVo!=null){
            if (StringUtils.isBlank(signVo.getSignId())){
                signVo.setSignId(UUIDGenerator.generate());
            }
            if (StringUtils.isBlank(signVo.getUserId())){
                signVo.setUserId(SessionUtil.getCurrentUserId());
            }
            if (StringUtils.isBlank(signVo.getSignName())){
                signVo.setSignName(userDAO.getUserVo(signVo.getUserId()).getUserName());
            }
            if (signVo.getSignDate()==null){
                signVo.setSignDate(Calendar.getInstance().getTime());
            }
        }
        return signVo;
    }

    private void UpdateBase64SignPic(String signId, String imgStr) {
        // 获取数据库操作语句
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn;
        try {
            DataSource ds = (DataSource) Container.getBean("egov");
            conn = ds.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select SIGN_PIC from PF_USERSIGN where SIGN_ID='" + signId + "' FOR UPDATE");
            if (rs.next()) {
                /* 取出此BLOB对象 */
                oracle.sql.BLOB blob = (oracle.sql.BLOB) rs.getBlob("SIGN_PIC");
                /* 向BLOB对象中写入数据 */
                BufferedOutputStream out = new BufferedOutputStream(blob.getBinaryOutputStream());
                if(StringUtils.isNotEmpty(imgStr)){
                   imgStr=imgStr.substring(imgStr.indexOf("data:image/bmp;base64,")+23) ;
                }
                ImageUtil.GenerateImage(imgStr,out);
            }
            conn.setAutoCommit(false);
            conn.commit();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                rs.close();
                stmt.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }

    }

    private void UpdateSignPic(String signId,String pnts) {
        // 获取数据库操作语句
//        Statement stmt = null;
//        ResultSet rs = null;
//        Connection conn;
        try {
//            DataSource ds = (DataSource) Container.getBean("egov");
//            conn = ds.getConnection();
//            conn.setAutoCommit(false);
//            stmt = conn.createStatement();
            ByteArrayOutputStream bOut=new ByteArrayOutputStream();
            PfSignVo signVo=new PfSignVo();
            if(StringUtils.isNotBlank(pnts)){
                if(pnts.indexOf(",")>0||pnts.indexOf("|")>0)    {
                    BufferedImage bufferImg = drawPic(pnts);               //鼠标点组成的jpg签名图片
                    ImageIO.write(bufferImg, "jpg", bOut);
                }else{
                    ImageUtil.GenerateImage(pnts,bOut);    //base64编码的签名jpg图片
                }
            }else if(StringUtils.isNotBlank(SessionUtil.getCurrentUserId())){
                SignUitl.BuildSignImage(SessionUtil.getCurrentUser().getUsername(), bOut);
            }

            signVo.setSignImage(bOut.toByteArray());
            signVo.setSignId(signId);
            signDAO.updateSignPic(signVo);

//            rs = stmt.executeQuery("select SIGN_PIC from PF_USERSIGN where SIGN_ID='" + signId + "' FOR UPDATE");
//
//            if (rs.next()) {
//                /* 取出此BLOB对象 */
//                oracle.sql.BLOB blob = (oracle.sql.BLOB) rs.getBlob("SIGN_PIC");
//                /* 向BLOB对象中写入数据 */
//                BufferedOutputStream out = new BufferedOutputStream(blob.getBinaryOutputStream());
//                ImageIO.write(bufferImg, "jpg", out);
//                out.close();
//            }
//            conn.setAutoCommit(false);
//            conn.commit();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
//            try {
//                rs.close();
//                stmt.close();
//            } catch (SQLException e) {
//                e.printStackTrace();
//            }
        }

    }

    @SuppressWarnings("unchecked")
    private BufferedImage drawPic(String strPoint) {
        boolean flage = true;
        Graphics2D graphic = null;
        BufferedImage bfimg = new BufferedImage(400, 160, BufferedImage.TYPE_INT_RGB);
        BasicStroke bs = new BasicStroke((float) 10.0);

        graphic = bfimg.createGraphics();
        graphic.setStroke(bs);
        graphic.setColor(new Color(255, 255, 255));
        graphic.fillRect(0, 0, 400, 160);
        int[] xPoints = new int[10000];
        int[] yPoints = new int[10000];
        int nPoints = 0, vNum = 0;
        int i = 0, j = 0, k = 0;
        Vector vctline = new Vector();
        String strline;
        strPoint = "|" + strPoint;
        for (i = 0; i < strPoint.length(); i++) {
            String line = new String();
            if (strPoint.charAt(i) != '|') {
                j = i + 1;
                k = 0;
                while (j < strPoint.length() && strPoint.charAt(j) != '|') {
                    line = line + strPoint.charAt(j);
                    j++;
                    k++;
                }
                i = i + k;
                k = 0;
                vctline.add(vNum++, line);
            }
        }
        k = 0;
        for (i = 0; i < vctline.size(); i++) {
            strline = vctline.get(i).toString();
            String strfig = "";
            int p = 0;
            for (j = 0; j < strline.length(); j++) {
                if (strline.charAt(j) == ',') {
                    p = j - 1;
                    strfig = "";
                    while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                        strfig = strline.charAt(p) + strfig;
                        p--;
                        if (p < 0) {
                            p = 0;
                            flage = false;
                        }
                    }
                    flage = true;
                    xPoints[k] = Integer.parseInt(strfig);
                    p = j + 1;
                    strfig = "";
                    while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                        strfig = strfig + strline.charAt(p);
                        p++;
                        if (p >= strline.length()) {
                            p = 0;
                            flage = false;
                        }
                    }
                    flage = true;
                    yPoints[k] = Integer.parseInt(strfig);
                    k++;
                    nPoints = k;
                }
            }
            k = 0;
            if (nPoints > 0) {
                graphic.setColor(new Color(0, 0, 0));
                graphic.drawPolyline(xPoints, yPoints, nPoints);
                nPoints = 0;
            }
        }
        graphic.setColor(new Color(0, 0, 0));
        graphic.drawPolyline(xPoints, yPoints, nPoints);
        return bfimg;
    }
}