package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysRoleDao;
import com.gtis.plat.service.SysRoleService;
import com.gtis.plat.vo.PfRoleVo;

import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/7
 */
public class SysRoleServiceImpl implements SysRoleService {
    private SysRoleDao sysRoleDao;
    /**
     * 新增角色
     *
     * @param pfRoleVo 角色对象
     */
    @Override
    public void insertRole(PfRoleVo pfRoleVo) {
        sysRoleDao.insertRole(pfRoleVo);
    }

    /**
     * 更新角色
     *
     * @param pfRoleVo 角色对象
     */
    @Override
    public void updateRole(PfRoleVo pfRoleVo) {
        sysRoleDao.updateRole(pfRoleVo);
    }

    /**
     * 根据角色Id批量删除角色
     *
     * @param roleIds
     */
    @Override
    public void deleteRole(List<String> roleIds) {
        sysRoleDao.deleteRole(roleIds);
    }

    public SysRoleDao getSysRoleDao() {
        return sysRoleDao;
    }

    public void setSysRoleDao(SysRoleDao sysRoleDao) {
        this.sysRoleDao = sysRoleDao;
    }
}
