package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysOrganDAO;
import com.gtis.plat.service.SysOrganService;
import com.gtis.plat.vo.PfOrganVo;

import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/7
 */
public class SysOrganServiceImpl implements SysOrganService {
    private SysOrganDAO sysOrganDAO;
    /**
     * 新增部门
     *
     * @param pfOrganVo 部门对象
     */
    @Override
    public void insertOrgan(PfOrganVo pfOrganVo) {
        sysOrganDAO.insertOrgan(pfOrganVo);
    }

    /**
     * 更新部门
     *
     * @param pfOrganVo 部门对象
     */
    @Override
    public void updateOrgan(PfOrganVo pfOrganVo) {
        sysOrganDAO.updateOrgan(pfOrganVo);
    }

    /**
     * 根据部门Id批量删除部门
     *
     * @param organIds
     */
    @Override
    public void deleteOrgan(List<String> organIds) {
        sysOrganDAO.deleteOrgan(organIds);
    }

    public SysOrganDAO getSysOrganDAO() {
        return sysOrganDAO;
    }

    public void setSysOrganDAO(SysOrganDAO sysOrganDAO) {
        this.sysOrganDAO = sysOrganDAO;
    }
}
