package com.gtis.plat.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysMessageDAO;
import com.gtis.plat.rss.RssBuilder;
import com.gtis.plat.vo.PfMessageAcceptAwokeVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import org.apache.commons.lang.time.DateUtils;
import org.apache.struts2.ServletActionContext;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@SuppressWarnings("unchecked")
public class SysNotifyRssBuilder extends ActionSupport implements RssBuilder {
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    private SyndFeed feed;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private List<PfMessageAcceptAwokeVo> acceptListRss;

    public SyndFeed getFeed(int arg0, int arg1) {
        SyndFeed feed = new SyndFeedImpl();
        // 设置必填项
        if (feed.getTitle() == null) {
            feed.setTitle("");
        }
        if (feed.getDescription() == null) {
            feed.setDescription("");
        }
        if (feed.getAuthor() == null) {
            feed.setAuthor("");
        }
        if (feed.getLink() == null) {
            feed.setLink("");
        }
        if (feed.getImage() != null) {
            feed.getImage().setUrl("");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        SysMessageAwokeServiceImpl notifyServiceImpl = (SysMessageAwokeServiceImpl) Container.getBean("SysNotifyServiceImpl");
        UserInfo userInfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
        //  paramsMap.put("notifyStadus", "1");
        if (userInfo.isAdmin()) {
            acceptListRss = notifyServiceImpl.getAcceptNotifyListRss(paramsMap);
        } else {
            paramsMap.put("acceptUserId", userInfo.getId());
            acceptListRss = notifyServiceImpl.getAcceptNotifyListRss(paramsMap);
        }
        List<SyndEntry> entries = new ArrayList<SyndEntry>();
        for (PfMessageAcceptAwokeVo vo : acceptListRss) {
            entries.add(convert(vo));
        }
        feed.setEntries(entries);
        return feed;
    }

    public String getUrl(String... params) {
        return AppConfig.getPlatFormUrl() + "/notify!detail.action?flag=accept&msgAcceptAwokeId=" + params[0];
    }

    public SyndEntry convert(Object param) {
        PfMessageAcceptAwokeVo vo = (PfMessageAcceptAwokeVo) param;
        SyndEntry entry = new SyndEntryImpl();
        String title = vo.getMessageSendAwokeVo().getMessageAwokeName();
        if (vo.getMessageAcceptStadus() == SysMessageDAO.MESSAGEACCEPT_STATUS1) {
            title = "<strong>" + vo.getMessageSendAwokeVo().getMessageAwokeName() + "</strong>";
        }
        if(DateUtils.addWeeks(new Date(),-1).before(vo.getMessageSendAwokeVo().getMessageAwokeDate())){
            title+="&nbsp;<img src=\"portal/images/new.gif\" alt=\"\"/>";
        }
        entry.setTitle(title);
        entry.setLink(this.getUrl(vo.getMessageAcceptId()));
        if (vo.getMessageSendAwokeVo().getMessageAwokeDate() != null) {
            entry.setPublishedDate(vo.getMessageSendAwokeVo().getMessageAwokeDate());
        }
        return entry;
    }

    public SyndFeed getFeed() {
        return feed;
    }

    public void setFeed(SyndFeed feed) {
        this.feed = feed;
    }

    public List<PfMessageAcceptAwokeVo> getAcceptListRss() {
        return acceptListRss;
    }

    public void setAcceptListRss(List<PfMessageAcceptAwokeVo> acceptListRss) {
        this.acceptListRss = acceptListRss;
    }
}
