package com.gtis.plat.service.impl;


import java.util.HashMap;
import java.util.List;
import com.gtis.plat.dao.SysMenuDao;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.vo.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.Cacheable;

public class SysMenuServiceImpl implements SysMenuService {
	private SysMenuDao menuDao;

	public SysMenuDao getMenuDao() {
		return menuDao;
	}

	public void setMenuDao(SysMenuDao menuDao) {
		this.menuDao = menuDao;
	}


    public List<PfMenuVo> getMenuListByRoles(String roles){
        return menuDao.getMenuListByRoles(roles);
    }

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysMenuService#getMenusByUserInfo(com.gtis.web.UserInfo)
	 */
	public List<PfMenuVo> getMenusByUserInfo(UserInfo userInfo){
		if (!userInfo.isAdmin()){
            String roles=userInfo.getRoleIds();
            if (StringUtils.isNotBlank(roles))
			    return menuDao.getMenuListByRoles(roles);
            else
                return menuDao.getMenuListByRoles("'-99'");
		}else{
			return this.getMenuListByRoles(null);
		}
		
	}

    /* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysMenuService#getResource(java.lang.String)
	 */
    @Cacheable(value="MenuCache",key="#rid+'Resource'")
    public PfResourceVo getResource(String rid) {
        return menuDao.getResource(rid);
    }


    public List<PfMenuVo> getRootMenuListByUserInfo(UserInfo userInfo,boolean Leaves) {
        if (!userInfo.isAdmin()){
			return menuDao.getRootMenuListByRoles(userInfo.getRoleIds(),Leaves);
		}else{
			return menuDao.getRootMenuListByRoles(null,Leaves);
		}
	}

    /**
	 * 根据角色获取二级菜单
	 * @param userInfo
	 * @return
	 */
	public List<PfMenuVo> getRootMenuChildsByRoles(UserInfo userInfo,String menuParentId) {
        if (!userInfo.isAdmin()){
			return menuDao.getRootMenuChildsByRoles(userInfo.getRoleIds(),menuParentId);
		}else{
			return menuDao.getRootMenuChildsByRoles(null,menuParentId);
		}
	}

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysMenuService#getResourceByCode(java.lang.String)
	 */
    @Cacheable(value="MenuCache",key="#code+'ResourceByCode'")
	public PfResourceVo getResourceByCode(String code) {
		return menuDao.getResourceByCode(code);
	}

    @Cacheable(value="MenuCache",key="#roles+#wdid+'ResourceByCode'")
	public List<PfResourceVo> getProjectMenu(String roles,String wdid){
		return menuDao.getProjectMenu(roles,wdid);
	}

    @Cacheable(value="MenuCache",key="#roles+'ProjectWorkFlowDefineIds'")
     public List<String> getProjectWorkFlowDefineIds(String roles){
        return menuDao.getProjectWorkFlowDefineIds(roles);
     }


    /**
	 * 根据角色获取系统菜单
	 * @param userInfo
	 * @return
	 */
	public List<PfMenuVo> getSysMenuByUserInfo(UserInfo userInfo) {
		if (!userInfo.isAdmin()){
			return menuDao.getSysMenuByRoles(userInfo.getRoleIds());
		}else{
			return menuDao.getSysMenuByRoles(null);
		}
	}

    @Cacheable(value="MenuCache",key="#workflowDefinitionId+'WorkFlowDefineRoleIds'")
    public List<String> getWorkFlowDefineRoleIds(String workflowDefinitionId) {
        return menuDao.getWorkFlowDefineRoleIds(workflowDefinitionId);
    }
}
