package com.gtis.plat.service.impl;

import java.util.HashMap;
import java.util.List;

import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.service.SysFormService;
import com.gtis.plat.vo.PFDynamicSignVo;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfFormDefineVo;
import com.gtis.plat.vo.PfUserSignVo;
import org.springframework.cache.annotation.Cacheable;
/**
 * 表单服务
 * 缓存：FormDefineCache
 */
public class SysFormServiceImpl implements SysFormService {
	SysWorkFlowDefineDao workFlowDefineDao;
	SysFormDao formDao;
	
	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysFormService#getFormDefine(com.gtis.plat.vo.PfFormDefineVo)
	 */
    @Cacheable(value="FormDefineCache",key="#formDefineVo.formDefinitionId+'BusinessByForm'")
	public PfBusinessVo getBusiness(PfFormDefineVo formDefineVo) {
		return workFlowDefineDao.getBusinessByResId(formDefineVo.getFormDefinitionId());
	}
	
	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysFormService#getFormDefine(java.lang.String)
	 */
    @Cacheable(value="FormDefineCache",key="#defineId+'FormById'")
	public PfFormDefineVo getFormDefine(String defineId) {
		return formDao.getFormDefine(defineId);
	}

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysFormService#getSignUserImage(java.lang.String)
	 */
    @Cacheable(value="FormDefineCache",key="#userId+'SignUserImage'")
	public PfUserSignVo getSignUserImage(String userId){
		return formDao.getSignUserImage(userId);
	}
	
	public SysWorkFlowDefineDao getWorkFlowDefineDao() {
		return workFlowDefineDao;
	}

	public void setWorkFlowDefineDao(SysWorkFlowDefineDao workFlowDefineDao) {
		this.workFlowDefineDao = workFlowDefineDao;
	}

	public SysFormDao getFormDao() {
		return formDao;
	}

	public void setFormDao(SysFormDao formDao) {
		this.formDao = formDao;
	}

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysFormService#getSign(java.lang.String)
	 */
    @Cacheable(value="FormDefineCache",key="#signId+'SignById'")
	public PfUserSignVo getSign(String signId){
		return formDao.getSign(signId);
	}
	
	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysFormService#createSign(com.gtis.plat.vo.PfUserSignVo)
	 */
	public void createSign(PfUserSignVo signVo){
		formDao.createSign(signVo);
	}

    @Cacheable(value="FormDefineCache",key="#defineId+'SimpleFormById'")
	public PfFormDefineVo getFormDefineSimple(String defineId){
		return formDao.getFormDefineSimple(defineId);
	}
	
}
