package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysDistrictDao;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.vo.PfDistrictVo;

import java.util.List;

/**
 * 平台工作流地区字典服务
 * Created by shenjian on 2014-05-20.
 */
public class SysDistrictServiceImpl implements SysDistrictService {
    private SysDistrictDao sysDistrictDao;
    /**
     * 获取所有的行政区
     *
     * @return
     */
    @Override
    public List<PfDistrictVo> queryAllDistrict() {
        return sysDistrictDao.queryAllDistrict();
    }

    /**
     * 根据行政区代码获取该行政区的所有子区信息
     *
     * @param districtCode
     * @return
     */
    @Override
    public List<PfDistrictVo> querySubDistrictByCode(String districtCode) {
        return sysDistrictDao.querySubDistrictByCode(districtCode);
    }

    public SysDistrictDao getSysDistrictDao() {
        return sysDistrictDao;
    }

    public void setSysDistrictDao(SysDistrictDao sysDistrictDao) {
        this.sysDistrictDao = sysDistrictDao;
    }
}
