package com.gtis.plat.service.impl;

import com.gtis.plat.service.SysCalendarService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class SysCalendarServiceImpl implements InitializingBean,SysCalendarService {
    static Logger logger = LoggerFactory.getLogger(SysCalendarServiceImpl.class);
    private Map<String,SysCalendarService> calendarServiceMap = new HashMap<String, SysCalendarService>();
    private String calendarServiceType;


    @Override
    public void afterPropertiesSet() throws Exception {
        if(calendarServiceMap==null) {
            logger.error("请配置日期计算服务！");
            return;
        }
        if(StringUtils.isBlank(calendarServiceType))
            calendarServiceType = "default";
        calendarServiceMap.get(calendarServiceType).reloadWorkdaysAndHolidays();
    }


    @Override
    public Date getOverTime(Date beginDate, String timeLimit) {
        return calendarServiceMap.get(calendarServiceType).getOverTime(beginDate,timeLimit);
    }

    @Override
    public Date getOverTime(Date beginDate, Integer timeLimit) {
        return calendarServiceMap.get(calendarServiceType).getOverTime(beginDate,timeLimit);
    }

    @Override
    public double getWorkDayHours(Date beginDate, Date endDate) {
        return calendarServiceMap.get(calendarServiceType).getWorkDayHours(beginDate,endDate);
    }

    @Override
    public Date getMaxDate() {
        return calendarServiceMap.get(calendarServiceType).getMaxDate();
    }

    @Override
    public boolean IsHoliday(Date bDate) {
        return calendarServiceMap.get(calendarServiceType).IsHoliday(bDate);
    }

    @Override
    public Date getNextWorkDay(Date bDate) {
        return calendarServiceMap.get(calendarServiceType).getNextWorkDay(bDate);
    }

    @Override
    public void reloadWorkdaysAndHolidays() {
        calendarServiceMap.get(calendarServiceType).reloadWorkdaysAndHolidays();
    }

    @Override
    public int getTimeLeft(Date overDate) {
        return calendarServiceMap.get(calendarServiceType).getTimeLeft(overDate);
    }

    public Map<String, SysCalendarService> getCalendarServiceMap() {
        return calendarServiceMap;
    }

    public void setCalendarServiceMap(Map<String, SysCalendarService> calendarServiceMap) {
        this.calendarServiceMap = calendarServiceMap;
    }

    public String getCalendarServiceType() {
        return calendarServiceType;
    }

    public void setCalendarServiceType(String calendarServiceType) {
        this.calendarServiceType = calendarServiceType;
    }

    @Override
    public List<Date> getWorkDateList(Date paramDate1, Date paramDate2) {
    	return calendarServiceMap.get(calendarServiceType).getWorkDateList(paramDate1,paramDate2);
    }

    @Override
    public List<Date> getHolidayList(Date paramDate1, Date paramDate2) {
    	return calendarServiceMap.get(calendarServiceType).getHolidayList(paramDate1,paramDate2);
    }
}
