/*
 * Project: tdsc
 *
 * File: AuditServiceImpl.java
 *
 * LastModified: 2011-02-23 04:41:35
 *
 * Copyright (c) 2011 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.service.impl;


import com.gtis.plat.dao.LogDAO;
import com.gtis.plat.service.LogManager;
import com.gtis.plat.vo.Log;
import com.gtis.util.ThreadPool;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-2-23
 */

public class LogManagerImpl implements LogManager {
    private LogDAO logDAO;
    private TransactionTemplate transactionTemplate;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(LogManagerImpl.class);

    public void setLogDAO(LogDAO logDAO) {
        this.logDAO = logDAO;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public void log(final Log log) {
        ThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRED);
                transactionTemplate.execute(new TransactionCallbackWithoutResult() {
                    @Override
                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        try {
                            logDAO.saveLog(log);
                        } catch (Exception ex) {
                            logger.error(ex.getMessage(), ex);
                        }
                    }
                });
            }
        });
    }

    public void log(String action, Object content) {
        Log log = Log.instance();
        log.setAction(action);
        log.setContent(String.valueOf(content));
        log(log);
    }

//    public Page<Log> search(String field, String operate, String keyword, Date startTime, Date endTime, int number, int size) {
//        return logDAO.search(field, operate, keyword, startTime, endTime, number, size);
//    }

    public void clean(Date startTime, Date endTime) {
        logDAO.clearLog(startTime, endTime);
    }
}
