package com.gtis.plat.service.impl;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Repository;

import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.Md5Util;
import com.gtis.plat.vo.PfSmsVo;

/**
 * 郑州中牟现场用的短信服务
 */
@Repository
public class CmccSmsZzZmServiceImpl extends SysSmsServiceImpl {
	private String smsUrl;//接口地址
	private String ecName;//集团客户名称
	private String apId;//用户名
	private String secretKey;//用户密码
	private String sign;//网关签名编码，必填，签名编码在中国移动集团开通帐号后分配，可以在云MAS网页端管理子系统-SMS接口管理功能中下载。
	private String addSerial;//扩展码，根据向移动公司申请的通道填写，如果申请的精确匹配通道，则填写空字符串("")，否则添加移动公司允许的扩展码

    public String sendMsg(PfSmsVo sms) throws Exception {
        String msg = "";
        if (sms != null) {
            //获取配置
            if (StringUtils.isNotBlank(sms.getMobileNo()))
                msg = sendSmsToMobile(sms.getContent(),  sms.getMobileNo());//tels.substring(0,tels.length()-1));
        }

        return msg;
    }

    public String sendSmsToMobile(String content, String mobile) {
        String returnMsg = "ok";
        if (StringUtils.isNotBlank(mobile)) {
            try {
                if (StringUtils.isNotBlank(smsUrl)) {
                    try {
                    	HttpPost httpPost = new HttpPost(smsUrl);
                    	JSONObject postData = new JSONObject();
                    	postData.put("apId", apId);
                    	postData.put("ecName", ecName);
                    	postData.put("secretKey", secretKey);
                    	postData.put("content", content);
                    	postData.put("mobiles", mobile);
                    	postData.put("addSerial", addSerial);
                    	postData.put("sign", sign);
                    	
                    	//组织mac md5加密
        	            StringBuffer stf = new StringBuffer();
        	            stf.append(ecName);
        	            stf.append(apId);
        	            stf.append(secretKey);
        	            stf.append(mobile);
        	            stf.append(content);
        	            stf.append(sign);
        	            stf.append(addSerial);
        	           
        	            System.out.println("macStr："+stf.toString());
        	            System.out.println("macMD5："+  Md5Util.Build(stf.toString()));
        	            postData.put("mac", Md5Util.Build(stf.toString()));
        	            
        	            System.out.println("postData："+postData.toString()); 
        	            
        	            //String postBase64Data = Base64.encodeBase64String(postData.toString().getBytes());
        	            String postBase64Data = new String(Base64.encodeBase64(postData.toString().getBytes()),"UTF-8");
        	            System.out.println("postData--Base64："+postBase64Data); 
        	            
        	            httpPost.setEntity(new StringEntity(postBase64Data, HTTP.UTF_8));
        	            HttpResponse httpResponse = new DefaultHttpClient().execute(httpPost);
        	            
        	            String resBody = EntityUtils.toString(httpResponse.getEntity());
        	            System.out.println("接口状态："+httpResponse.getStatusLine().getStatusCode());
        	            System.out.println("接口结果："+resBody);
                      

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                returnMsg = "error";
            }
        }
        return returnMsg;
    }

	public String getSmsUrl() {
		return smsUrl;
	}

	public void setSmsUrl(String smsUrl) {
		this.smsUrl = smsUrl;
	}

	public String getEcName() {
		return ecName;
	}

	public void setEcName(String ecName) {
		this.ecName = ecName;
	}

	public String getApId() {
		return apId;
	}

	public void setApId(String apId) {
		this.apId = apId;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getAddSerial() {
		return addSerial;
	}

	public void setAddSerial(String addSerial) {
		this.addSerial = addSerial;
	}

	public String getSecretKey() {
		return secretKey;
	}

	public void setSecretKey(String secretKey) {
		this.secretKey = secretKey;
	}
}
