package com.gtis.plat.service.impl;

import cn.gtmap.sms.cmcc.xy.schema.sms.MessageFormat;
import cn.gtmap.sms.cmcc.xy.schema.sms.SendMethodType;
import cn.gtmap.sms.cmcc.xy.schema.sms.SendSmsRequest;
import cn.gtmap.sms.cmcc.xy.schema.sms.SendSmsResponse;
import cn.gtmap.sms.cmcc.xy.service.Cmcc_mas_wbsProxy;

import com.gtis.plat.vo.PfSmsVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;



/**
 * 新沂移动短信接口
 */
@Repository
public class CmccSmsXYServiceImpl extends SysSmsServiceImpl {
    private String appID;

    private String smsUrl;

    public String sendMsg(PfSmsVo sms) throws Exception {
        String msg = "";
        if (sms != null) {
            //获取配置
            if (StringUtils.isNotBlank(sms.getMobileNo()))
                msg = sendSmsToMobile(sms.getContent(),  sms.getMobileNo());//tels.substring(0,tels.length()-1));
        }

        return msg;
    }

    public String sendSmsToMobile(String content, String mobile) {
        String returnMsg = "ok";
        if (StringUtils.isNotBlank(mobile)) {
            String[] mobileAry = StringUtils.split(mobile);
            List<String> mobileList = Arrays.asList(mobileAry);
            //清理费正常格式的电话号码
            for (int i = 0; i < mobileList.size(); i++) {
                if (StringUtils.isBlank(mobileList.get(i)) || !isNumeric(mobileList.get(i))){
                    mobileList.remove(i);
                    i--;
                }
            }
            String[] phoneAry = new String[mobileList.size()];
            for (int i = 0; i < mobileList.size(); i++) {
                phoneAry[i]="tel:"+mobileList.get(i);
            }
            try {
                //String url = "http://218.206.140.188:8081/webservice2/services/cmcc_mas_wbs";
                Cmcc_mas_wbsProxy obj = new Cmcc_mas_wbsProxy(smsUrl);

                //设置http限制
                //stub._getServiceClient().getOptions().setProperty(HTTPConstants.CHUNKED, false);

                SendSmsRequest request=new SendSmsRequest();
                request.setApplicationID(appID);
                request.setDeliveryResultRequest(true);
                request.setExtendCode("");
                request.setMessage(content);
                request.setMessageFormat(MessageFormat.GB2312);
                request.setSendMethod(SendMethodType.Long);

                org.apache.axis.types.URI[] ary=new org.apache.axis.types.URI[phoneAry.length];
                for(int i=0;i<phoneAry.length;i++){
                    org.apache.axis.types.URI temp=new org.apache.axis.types.URI(phoneAry[i]);
                    ary[i]=temp;
                }
                request.setDestinationAddresses(ary);

                //发送短信
                SendSmsResponse response=obj.sendSms(request);
                //获取标示
                String requestIdentifier=response.getRequestIdentifier();

                System.out.println(requestIdentifier);
                //154dbfcb-6758-4cb8-9475-b4c94aa49cb8
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnMsg;
    }

    public static boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public String getAppID() {
        return appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getSmsUrl() {
        return smsUrl;
    }

    public void setSmsUrl(String smsUrl) {
        this.smsUrl = smsUrl;
    }
}
