package com.gtis.plat.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfSmsVo;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;

/**
 * 扬中现场用的短信服务
 */
@Repository
public class CmccSmsServiceImpl extends SysSmsServiceImpl {
	private String smsUrl;

    public String sendMsg(PfSmsVo sms) throws Exception {
        String msg = "";
        if (sms != null) {
            //获取配置
            if (StringUtils.isNotBlank(sms.getMobileNo()))
                msg = sendSmsToMobile(sms.getContent(),  sms.getMobileNo());//tels.substring(0,tels.length()-1));
        }

        return msg;
    }

    public String sendSmsToMobile(String content, String mobile) {
        String returnMsg = "ok";
        if (StringUtils.isNotBlank(mobile)) {
            try {
                HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
                connectionManager.getParams().setConnectionTimeout(30000);
                connectionManager.getParams().setSoTimeout(30000);
                HttpClient httpClient = new HttpClient(connectionManager);
                if (StringUtils.isNotBlank(smsUrl)) {
                    try {
                        PostMethod postMethod = new PostMethod(smsUrl);
                        postMethod.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "UTF-8");
                        NameValuePair[] postData = new NameValuePair[2];
                        postData[0] = new NameValuePair("content", content);
                        postData[1] = new NameValuePair("mobile", mobile);
                        postMethod.addParameters(postData);

                        httpClient.executeMethod(postMethod);

                        postMethod.releaseConnection();

                    } catch (SocketTimeoutException eTimeOut) {
                        eTimeOut.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                returnMsg = "error";
            }
        }
        return returnMsg;
    }

	public String getSmsUrl() {
		return smsUrl;
	}

	public void setSmsUrl(String smsUrl) {
		this.smsUrl = smsUrl;
	}
}
