package com.gtis.plat.service.impl;

import com.gtis.plat.vo.PfSmsVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import com.jasson.mas.api.ApiException;
import com.jasson.mas.api.common.ConnectStatus;
import com.jasson.mas.api.sms.SmsApiClient;
import com.jasson.mas.api.sms.SmsApiClientHandler;
import com.jasson.mas.api.sms.SmsApiClientImpl;
import com.jasson.mas.api.smsapi.MsgFmt;
import com.jasson.mas.api.smsapi.SmsSendRequest;
import com.jasson.mas.api.smsapi.SmsSendResponse;
import com.jasson.mas.api.smsapi.SmsType;

import java.util.*;
import java.util.regex.Pattern;

/**
 * 常州移动短信接口
 */
@Repository
public class CmccSmsCZServiceImpl extends SysSmsServiceImpl {
    private String appID;

    private String appPwd;

    private String xcode;

    private int masApiPort;

    private String masIP;

    public String sendMsg(PfSmsVo sms) throws Exception {
        String msg = "";
        if (sms != null) {
            //获取配置
            if (StringUtils.isNotBlank(sms.getMobileNo()))
                msg = sendSmsToMobile(sms.getContent(),  sms.getMobileNo());//tels.substring(0,tels.length()-1));
        }

        return msg;
    }

    public String sendSmsToMobile(String content, String mobile) {
        String returnMsg = "ok";
        if (StringUtils.isNotBlank(mobile)) {
            String[] mobileAry = StringUtils.split(mobile);
            List<String> mobileList = Arrays.asList(mobileAry);
            //清理费正常格式的电话号码
            for (int i = 0; i < mobileList.size(); i++) {
                if (StringUtils.isBlank(mobileList.get(i)) || !isNumeric(mobileList.get(i))){
                    mobileList.remove(i);
                    i--;
                }
            }

            //通过移动插件发送
            SmsApiClient smsApiClient = null;
            SmsApiClientHandler smsHandler = new SmsApiClientHandlerImpl();
            smsApiClient = new SmsApiClientImpl(smsHandler, masIP, masApiPort, appID, appPwd);
            try {
                smsApiClient.start();

                //设置是否自动重连到服务器(可以不需要设置)
                smsApiClient.setAutoConnect (true);

                //设置自动重连服务器相隔时间(单位：秒), 默认为30秒(可以不需要设置)
                smsApiClient.setReConnectInterval (60);

                //设置与服务连接超时时长，单位：millisecond(可以不需要设置)
                smsApiClient.setConnectTimeout(100000);

                //设置发送超时时长，单位：millisecond(可以不需要设置)
                smsApiClient.setSendTimeout(1000000);

                //获取网关连接状态(Connect：连接正常, Disconnect：断连, NotConnect：没有连接, Other：其他)
                ConnectStatus connectStatus= smsApiClient.getConnStatusIAGW();
                System.out.println((new StringBuilder("connectStatus=")).append(connectStatus).toString());
                if (!ConnectStatus.Connect.equals(connectStatus)) {
                    System.out.println("网关未连接");
                    returnMsg = "error";
                }
                System.out.println("网关已连接");
                SmsSendRequest smsSendRequest = new SmsSendRequest();

                smsSendRequest.destAddrs = mobileList;
                smsSendRequest.validTime = 10000; // 短信存活期，单位秒
                smsSendRequest.xCode = xcode; //短信扩展码
                smsSendRequest.message = content; //短信内容
                smsSendRequest.msgFormat =MsgFmt.GB2312; //短信编码类型
                smsSendRequest.isNeedReport = true; //短信是否需要状态报告
                smsSendRequest.priority = 1; //短信网关优先级, 短信优先级大于0 的整数 0为最高优先级，数字越大级别越低
                // Normal: 普通短信,Instant：免提短信, Long：长短信,Structured：二进制短信,WapPush：WapPush短信
                smsSendRequest.type = SmsType.Normal;
                smsSendRequest.appID = appID;

                //＝＝＝＝＝＝构造发送短信对象结束＝＝＝＝＝＝＝
                SmsSendResponse smsSendResponse = smsApiClient.sendSms(smsSendRequest);
                System.out.println("提交成功，requestID:" + smsSendResponse.requestID);
            } catch (ApiException e) {
                e.printStackTrace();
                System.out.println("API短信客户端调用失败:" + e.getMessage());
                returnMsg = "error";
            } finally {
                smsApiClient.close();
            }
        }
        return returnMsg;
    }

    public static boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public String getAppID() {
        return appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getAppPwd() {
        return appPwd;
    }

    public void setAppPwd(String appPwd) {
        this.appPwd = appPwd;
    }

    public String getXcode() {
        return xcode;
    }

    public void setXcode(String xcode) {
        this.xcode = xcode;
    }

    public int getMasApiPort() {
        return masApiPort;
    }

    public void setMasApiPort(int masApiPort) {
        this.masApiPort = masApiPort;
    }

    public String getMasIP() {
        return masIP;
    }

    public void setMasIP(String masIP) {
        this.masIP = masIP;
    }
}
