/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: Site.java
 *
 * LastModified: 2009-11-30 07:56:23
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.portal.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-11-30
 */
public class Site implements Serializable, Cloneable {

    public final static String GLOBAL_SITE = "global";
    public static final String ROLE_SITE_PREFIX = "role_";

    private String owner;
    List<Page> pages = new ArrayList<Page>();
    private static final long serialVersionUID = 8064904303540243832L;

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<Page> getPages() {
        return pages;
    }

    public void setPages(List<Page> pages) {
        this.pages = pages;
    }

    @Override
    public Site clone() throws CloneNotSupportedException {
        return (Site) super.clone();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
