/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: Page.java
 *
 * LastModified: 2009-11-30 04:46:05
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.portal.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-11-30
 */
public class Page implements Serializable, Cloneable {

    private String name;
    private String Layout;
    private List<Fragment> fragments = new ArrayList<Fragment>();
    private static final long serialVersionUID = -2479554133011531217L;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLayout() {
        return Layout;
    }

    public void setLayout(String layout) {
        Layout = layout;
    }

    public List<Fragment> getFragments() {
        return fragments;
    }

    public void setFragments(List<Fragment> fragments) {
        this.fragments = fragments;
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Page)) {
            return false;
        }
        Page n = (Page) o;
        return name != null && name.equals(n.getName());
    }

    @Override
    public Page clone() throws CloneNotSupportedException {
        return (Page) super.clone();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
