/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: PortalDao.java
 *
 * LastModified: 2009-11-30 08:40:13
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.portal;

import com.gtis.plat.portal.model.PortletEntity;
import com.gtis.plat.portal.model.Site;

import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-11-30
 */
public interface PortalDao {

    PortletEntity getPortletEntity(String id);

    List<PortletEntity> getPortletEntities();

    PortletEntity savePortletEntity(PortletEntity portletEntity);

    void removePortletEntity(String id);

    boolean portletEntityExist(String id);

    Site getSite(String owner);

    Site saveSite(Site site);

    void removeSite(String owner);

    boolean siteExist(String owner);

    void resetUserSite();

    Map<String,Site> getRoleSitesMap();
}
