package com.gtis.plat.form.print;


import com.gtis.config.AppConfig;
import com.gtis.plat.datasource.BusinessDataSource;
import com.gtis.plat.form.*;
import com.gtis.plat.form.print.xmlutil.ResultSetXml;
import com.gtis.plat.form.print.xmlutil.SqlStrXml;
import com.gtis.plat.form.print.xmlutil.VoListXml;
import com.gtis.plat.form.print.xmlutil.VoXml;
import com.gtis.spring.Container;
import com.gtis.util.DataSourceManager;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class XMLBuildHelper {

	
	FormInstanceFactory instanceFactory = (FormInstanceFactory) Container
		.getBean("FormInstanceFactory");
	
	private static final org.apache.commons.logging.Log log = LogFactory
	.getLog(XMLBuildHelper.class);
	

	/**对vo进行处理**/
	public String voToXml(Object vo)
	{
		VoXml vxml=new VoXml(vo);
		return vxml.getXMLData();
	}
	
	/**对vo集进行处理**/
	public String voListToXml(List volist)
	{
		VoListXml vlxml=new VoListXml(volist);
		return vlxml.getXMLData();
	}
	
	/**对结果集进行处理**/
	public String resultSetToXml(ResultSet rs,String datatype)
	{
		ResultSetXml rsx=new ResultSetXml( rs,datatype);
		return rsx.getXMLData();
	}
	
	/**对SQL语句进行处理**/
	public String sqlstrToXml(String sqlstr,String jndi,String datatype)
	{
		SqlStrXml ssx=new SqlStrXml( sqlstr, jndi, datatype);
		return ssx.getXMLData();
	}
	
	//构造报表打印所需要的数据集
	public String buildXmlDataSet(HttpServletRequest request,
			HttpServletResponse response, String dfId, String proId) throws Exception{
		return buildXmlDataSet(request,response,dfId,proId,null);
	}
	//构造报表打印所需要的数据集
		public String buildXmlDataSet(HttpServletRequest request,
				HttpServletResponse response, String dfId, String proId,HashMap queryParam) throws Exception{
			
			StringBuffer iframeBuffer = new StringBuffer();
			StringBuffer xml = new StringBuffer();
			xml.append("<?xml version=\"1.0\" encoding=\"gbk\" ?> ");
			xml.append("<fetchdatas>");
			createXmlData(request,response,xml, dfId, proId, iframeBuffer,queryParam);
			//此处增加表单数据
			
			xml.append(iframeBuffer);//增加子表的表单数据
			
			xml.append("</fetchdatas>");
			return xml.toString();
		}
	
	public static Document getXlstDocument(String xlstStr){
		SAXReader saxReader = new SAXReader();
		try {
			Document document = DocumentHelper.parseText(xlstStr);
			return document;
			
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		} 
	}
	
	/**
	 * 获取类型是iframe的元素的IDmap对象
	 * @param doc
	 * @return
	 */
	public static HashMap getIframeElementIdMap(Document doc) {
		HashMap resultMap = new HashMap();
		List nodeList = doc.selectNodes("//xsl:with-param[contains(text(),\"iframe\")]");
		if (nodeList != null && nodeList.size() > 0) {
			for (int i = 0; i < nodeList.size(); i++) {
				Element tempNode = (Element) nodeList.get(i);
				String nameAttr = tempNode.attributeValue("name");
				if (nameAttr == null || !nameAttr.equalsIgnoreCase("ClassName")) {
					continue;
				}
				Element paraElement = tempNode.getParent();
				String paraElementName = paraElement.getName();
				if (paraElementName == null
						|| paraElementName
								.indexOf("apply-templates")==-1) {
					continue;
				}
				String selectValue = paraElement.attributeValue("select");
				int firstPos = selectValue.indexOf("'");
				int secondPos = selectValue.lastIndexOf("'");
				if (firstPos == -1 || secondPos == -1 || firstPos >= secondPos) {
					continue;
				}
				
				String id = selectValue.substring(firstPos+1, secondPos);
				if (id == null || id.length() == 0) {
					continue;
				}
				resultMap.put(id, id);
			}
		}
		return resultMap;
	}
		
	
	public void createXmlData(HttpServletRequest request,
			HttpServletResponse response, StringBuffer xml, String dfId,
			String proId, StringBuffer iframeBuffer,HashMap queryParam) throws Exception{

        String httpurl= AppConfig.getPlatFormUrl();

        FormSqlProcessor formSqlProcessor = (FormSqlProcessor) Container
                .getBean("FormSqlProcessor");
		FormInstance formInstance = instanceFactory.createFormInstance(dfId);
		formInstance.setQueryParam(queryParam);
		formInstance.setProId(proId);
		
		Document docInstance = null;
		DataSource ds = BusinessDataSource.getDataSourceByBusiness(formInstance
				.getBusinessVo());
		String selectSql = formInstance.getFormDefineVo().getSelectCommand();
//		selectSql = FormSqlBuilder.replaceProIdSql(selectSql, formInstance
//				.getProId());
        selectSql =formSqlProcessor.processor(selectSql, formInstance.getProId(),formInstance.getQueryParam());
		Map iframeIdMap = getIframeElementIdMap(getXlstDocument(formInstance.getFormDefineVo().getDefinitionXlst()));
		
		Connection conn = null;
		ResultSet rs = null;
		Statement st = null;
		 
		
		try {
			conn = ds.getConnection();
			st = conn.createStatement();
			rs = st.executeQuery(selectSql);
			xml.append("<datas>");
			docInstance = FormXmlBuilder.getBlankXML(formInstance);
			if (rs.next()) {
				List lstNode = docInstance.selectNodes("//DataSet/ElementData");
				for (int i = 0; i < lstNode.size(); i++) {
					Element elementData = (Element) lstNode.get(i);
					if (!elementData.valueOf("@Id").equals("")) {
						String fieldname = elementData.valueOf("@Id");
						String datatype= "String";
						String type= elementData.valueOf("@Type");
						String fieldvalue=FormXmlBuilder.getValue(rs, elementData
								.valueOf("@Id"));
						
						String defaultValue= elementData.valueOf("@DefaultValue");
						
						
						if(fieldvalue==null || fieldvalue.equalsIgnoreCase("null")){
							fieldvalue = "";
							
						}
                        String tempSignId = "";
						if(type.equalsIgnoreCase("Sign")){
							if (fieldvalue.length()>0){//判断fieldvalue的值是否为空，为空的话 图片路径传空。
                                tempSignId =  fieldvalue;
								fieldvalue  = httpurl+"/formprint.action?datatype=signature&signid=" + fieldvalue;
								}
							else{
								fieldvalue = "";
							}
							datatype = "image";
                            //这里需要考虑会签的多个签名的情况
                            if (!org.apache.commons.lang.StringUtils.isBlank(defaultValue)){
                                xml.append(buildAllSignInfoXml(httpurl,fieldname,defaultValue,proId));
                                continue;
                            }
						}

						if(iframeIdMap.containsKey(fieldname)){
							//System.out.println("-+++++++++++==xml="+xml.toString());
							
							iframeBuffer.append(getIframePrintData(request,response,defaultValue,dfId,proId, fieldname));
							//xml.append(getIframePrintData(request,response,defaultValue,dfId,proId, fieldname));
							//System.out.println("-----------xml="+xml.toString());
						}else{
							xml.append( "<data name=\""+ fieldname +"\" type =\""+datatype+"\"><![CDATA[" + fieldvalue +"]]></data>") ;
                            if (type.equalsIgnoreCase("Sign")){
                                if(fieldvalue.length() > 0){
                                    xml.append(buildSignInfoXml(fieldname,tempSignId));
                                }else{
                                    //如果此处签名没有，则给予空字符串
                                   xml.append( "<data name=\""+ fieldname +"_NAME\" type =\"String(50)\"></data>") ;
                                   xml.append( "<data name=\""+ fieldname +"_DATE\" type =\"String(50)\"></data>") ;
                                }
                            }

						}
					}
				}

			}
            xml.append( "<data name=\"projectId\" type =\"String(50)\">"+proId+"</data>") ;
			xml.append("</datas>");
			xml.append(FormXmlBuilder.buildGridPrintXml(formInstance, conn));
		} catch (Exception e) {
			
			log.error("报表SQL定义错误"
					+ formInstance.getFormDefineVo().getFormDefinitionId()
					+ "，请检查！" + selectSql, e);
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(conn);
		}
	}


    /**
     * 构造签名信息
     * @param 
     * @param signId
     * @return
     */
    private String buildSignInfoXml(String signField,String signId){
        StringBuffer strBuf = new StringBuffer();

         Connection con = null;
        try{
            DataSource ds = DataSourceManager.getDataSource();
            con=ds.getConnection();
            Statement stmt = con.createStatement();
            String sql = "select SIGN_NAME,SIGN_DATE from pf_usersign u where u.sign_id='"+signId+"'";
            ResultSet resultRs = stmt.executeQuery(sql);
            while(resultRs.next()){
                String signName= resultRs.getString("SIGN_NAME");
                java.util.Date signDate =  resultRs.getDate("SIGN_DATE");
                strBuf.append( "<data name=\""+ signField +"_NAME\" type =\"String(50)\"><![CDATA[" + signName +"]]></data>") ;
                SimpleDateFormat formatter = new SimpleDateFormat ("yyyy-MM-dd");
                if (signDate!=null){
                    strBuf.append( "<data name=\""+ signField +"_DATE\" type =\"String(50)\"><![CDATA[" + formatter.format(signDate) +"]]></data>") ;
                }else{
                    strBuf.append( "<data name=\""+ signField +"_DATE\" type =\"String(50)\"></data>") ;
                }
                break;
            }
            DataSourceManager.attemptClose(con);
        }catch(Exception ex){
            ex.printStackTrace();
        }finally{
            if (con!=null){
                con = null;
            }
        }
        return  strBuf.toString();
    }

     /**
     * 构造会签签名信息
     * @param
     * @param proId
     * @return
     */
    private String buildAllSignInfoXml(String httpurl,String signField,String signKey,String proId){
        StringBuffer strBuf = new StringBuffer();
        int index=0;
         Connection con = null;
        try{
            DataSource ds = DataSourceManager.getDataSource();
            con=ds.getConnection();
            Statement stmt = con.createStatement();
            String sql = "select SIGN_ID,SIGN_OPINION,SIGN_NAME,SIGN_DATE from pf_usersign u where u.SIGN_KEY='"+signKey+"' and u.PRO_ID='"+proId+"'";
            ResultSet resultRs = stmt.executeQuery(sql);
            while(resultRs.next()){
                String signId= resultRs.getString("SIGN_ID");
                strBuf.append( "<data name=\""+ signField +"_"+index+"\" type =\"image\"><![CDATA[ "+httpurl+"/formprint.action?datatype=signature&signid=" +signId+"]]></data>") ;
                String signName= resultRs.getString("SIGN_NAME");
                java.util.Date signDate =  resultRs.getDate("SIGN_DATE");
                strBuf.append( "<data name=\""+ signField +"_NAME_"+index+"\" type =\"String(50)\"><![CDATA[" + signName +"]]></data>") ;
                String signOpinion= resultRs.getString("SIGN_OPINION");
                if (org.apache.commons.lang.StringUtils.isBlank(signOpinion))  signOpinion="";
                strBuf.append( "<data name=\""+ signField +"_YJ_"+index+"\" type =\"String(50)\"><![CDATA[" + signOpinion +"]]></data>") ;
                SimpleDateFormat formatter = new SimpleDateFormat ("yyyy-MM-dd");
                if (signDate!=null){
                    strBuf.append( "<data name=\""+ signField +"_DATE_"+index+"\" type =\"String(50)\"><![CDATA[" + formatter.format(signDate) +"]]></data>") ;
                }else{
                    strBuf.append( "<data name=\""+ signField +"_DATE_"+index+"\" type =\"String(50)\"></data>") ;
                }
                /////考虑到只有一个签名的情况支持不用循环的打印输出,为了结合模板的设计
                if (index==0){
                    strBuf.append( "<data name=\""+ signField +"\" type =\"image\"><![CDATA[ "+httpurl+"/formprint.action?datatype=signature&signid="+signId+"]]></data>") ;
                    strBuf.append( "<data name=\""+ signField +"\" type =\"String(50)\"><![CDATA[" + signName +"]]></data>") ;
                    strBuf.append( "<data name=\""+ signField +"_YJ\" type =\"String(50)\"><![CDATA[" + signOpinion +"]]></data>") ;
                    strBuf.append( "<data name=\""+ signField +"_DATE\" type =\"String(50)\"><![CDATA[" + formatter.format(signDate) +"]]></data>") ;
                }
                index++;
            }
            strBuf.append( "<data name=\""+ signField +"_NUM\" type =\"Long\">"+index+"</data>") ;
            if (index==0){    //考虑没有签名的情况
                strBuf.append( "<data name=\""+ signField +"\" type =\"image\"></data>") ;
                strBuf.append( "<data name=\""+ signField +"\" type =\"String(50)\"></data>") ;
                strBuf.append( "<data name=\""+ signField +"_YJ\" type =\"String(50)\"></data>") ;
                strBuf.append( "<data name=\""+ signField +"_DATE\" type =\"String(50)\"></data>") ;
            }
            DataSourceManager.attemptClose(con);
        }catch(Exception ex){
            ex.printStackTrace();
        }finally{
            if (con!=null){
                con = null;
            }
        }
        return  strBuf.toString();
    }
	/**
	 * 调用Iframe页面的打印url,获取IFrame内的打印数据
	 * @param defaultValue
	 * @param dfId
	 * @param proId
	 * @return
	 */
	public String getIframePrintData(HttpServletRequest request,
			HttpServletResponse response,String defaultValue,String dfId,String proId,String iframeId){
		String printData = "";
		if 	(defaultValue == null || defaultValue.trim().length()==0){
			return printData;
		}
		if (defaultValue.indexOf("?")>0){
			defaultValue = defaultValue.substring(defaultValue.indexOf("?")+1,defaultValue.length());
		}
		String[] paraArray = defaultValue.split("&");
		if (paraArray != null && paraArray.length > 0) {
			for (int m = 0; m < paraArray.length; m++) {
				String[] tempArray = paraArray[m].trim().split("=");
				if (tempArray == null || tempArray.length != 2) {
					continue;
				}
				if (tempArray[0].trim().equalsIgnoreCase("printurl")) {
					StringBuffer printUrlBuf = new StringBuffer();
					
					String host = ServletActionContext.getRequest().getServerName();
					String port =   ServletActionContext.getRequest().getServerPort() + "";
					String context = ServletActionContext.getRequest().getContextPath();
					String httpurl = "http://" + host +":"+ port;
					String contextUrl = "http://" + host +":"+ port + context;
					String path = tempArray[1].trim();
					String lowerCasePath = path.toLowerCase();
					if (lowerCasePath.indexOf("http") < 0){
						//如果没有指定全路径，则认为是该tomcat下面的资源
						if (lowerCasePath.charAt(0)=='/'){
							//如果是带斜线，则认为是服务器上的同一tomcat下部署的其他war包的服务
							path = httpurl + path;
						}else{
							path = contextUrl+"/"+ path;
						}
					}
					
					printUrlBuf.append(path);
					printUrlBuf.append("?proid=");
					printUrlBuf.append(proId);
					printUrlBuf.append("&dfid=");
					printUrlBuf.append(dfId);
					printUrlBuf.append("&iframeid=");
					printUrlBuf.append(iframeId);				
					
					try {
						URL url = new URL(printUrlBuf.toString());
						URLConnection connection = url.openConnection();
						connection.connect();
						HttpURLConnection httpURLConnection = (HttpURLConnection) connection;
						int httpResult = httpURLConnection.getResponseCode();
						InputStream is =  httpURLConnection.getInputStream();
						if (httpResult != HttpURLConnection.HTTP_OK) {
//							System.out.println("没有连接成功");
							
						} else {
//							System.out.println("连接成功了　");
							printData = convertStreamToString(is);
//							System.out.println("----------printData="+printData);
						}
					}catch(Exception ex){
						ex.printStackTrace();
					}

				}
			}
		}
		return printData;
	}
	
	
	/**
	 * 把InputStream对象转换成字符串
	 * @param is
	 * @return
	 */
	   public String convertStreamToString(InputStream is) {

	        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
	        StringBuilder sb = new StringBuilder();
	        String line = null;
	        try {
	            while ((line = reader.readLine()) != null) {
	                sb.append(line + "\n");
	                //System.out.println(">>>>>>>>>>>>>>>>line="+line);
	            }
	        } catch (IOException e) {
	            e.printStackTrace();
	        } finally {
	            try {
	                is.close();
	            } catch (IOException e) {
	                e.printStackTrace();
	            }
	        }
	        return sb.toString();
	    }

	
	public FormInstanceFactory getInstanceFactory() {
		return instanceFactory;
	}

	public void setInstanceFactory(FormInstanceFactory instanceFactory) {
		this.instanceFactory = instanceFactory;
	}


	public static void main(String[] argv){
        System.out.println("asdf");
		
	}
}
