package com.gtis.plat.form;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;

import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;

import com.gtis.plat.service.SysFormService;
import com.gtis.plat.wf.WorkFlowXmlUtil;

public class FormScript {

	private static final org.apache.commons.logging.Log log = LogFactory
	.getLog(FormScript.class);
	
	public static void runSave(Map requestMap,String defineId,String proId) {
		FormModel formModel = FormModelFactory.getFormModel(defineId);
		Document shellDoc=formModel.getDefinitionShell();
		if (shellDoc!=null){
			String scriptText=shellDoc.selectSingleNode("//Event[@name='Form_Save']").getText();
			if (scriptText!=null && !scriptText.equals("")){
				HashMap<String,Object> map=new HashMap<String, Object>();
				map.put("request", requestMap);
				map.put("defineId", defineId);
				map.put("proId", proId);
				runScript(map,scriptText);
			}
		}
	}
	
	public static void runLoad(Document doc,String defineId,String proId) {
		FormModel formModel = FormModelFactory.getFormModel(defineId);
		Document shellDoc=formModel.getDefinitionShell();
		if (shellDoc!=null){
			String scriptText=shellDoc.selectSingleNode("//Event[@name='Form_Load']").getText();
			if (scriptText!=null && !scriptText.equals("")){
				HashMap<String,Object> map=new HashMap<String, Object>();
				map.put("doc", doc);
				map.put("defineId", defineId);
				map.put("proId", proId);
				runScript(map,scriptText);
			}
		}
	}
	
	public static void runScript(String scriptText) {
		try {
			GroovyShell gs=new GroovyShell();
			gs.evaluate(scriptText);
		} catch (Exception e) {
			log.error("-----表单脚本异常！------\r\n" +scriptText ,e);
		}
	}
	
	public static void runScript(HashMap<String,Object> mapParams,String scriptText) {
		try {
			Binding b = new Binding();
			Iterator iter = mapParams.entrySet().iterator(); 
			while (iter.hasNext()) { 
				Map.Entry entry = (Map.Entry) iter.next(); 
			    Object key = entry.getKey(); 
			    Object val = entry.getValue(); 
			    b.setVariable(key.toString(), val);
			}
			GroovyShell gs=new GroovyShell(b);
			gs.evaluate(scriptText);
		} catch (Exception e) {
			log.error("-----表单脚本异常！------\r\n" +scriptText ,e);
		}
	}
	
	public static void main(String[] args) {
//		Binding b = new Binding(); 
//		b.setVariable("FormModelFactory", FormModelFactory.class);//向脚本中的$test传入对象"Kevin" 
		
		
		HashMap<String, String> gobalMap =new HashMap<String, String>();
		gobalMap.put("DAYS", "1");
		Binding b = new Binding();
		Iterator iter = gobalMap.entrySet().iterator(); 
		while (iter.hasNext()) { 
			Map.Entry entry = (Map.Entry) iter.next(); 
		    Object key = entry.getKey(); 
		    Object val = entry.getValue(); 
		    b.setVariable(key.toString(), val);
		} 
		
		GroovyShell gs=new GroovyShell(b);
		
		StringBuffer str=new StringBuffer();
		//str.append("println 'hhhh'");
//		str.append(" def DAYS=1 ");
//		str.append("\r\n");
		str.append(" println DAYS>'0' ");
		
		gs.evaluate(str.toString());
	}
	
}
