package com.gtis.plat.form;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.sql.DataSource;

import com.gtis.spring.Container;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.datasource.BusinessDataSource;
import com.gtis.plat.service.SysFormService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfFormDefineVo;
import com.gtis.util.DataSourceManager;
import com.gtis.util.StaticParamHelper;
import org.springframework.jdbc.core.JdbcTemplate;

public class FormInstanceFactory {
    private FormSqlProcessor formSqlProcessor;

	SysFormService formService;
	private static final org.apache.commons.logging.Log log = LogFactory
    .getLog(FormInstanceFactory.class);

    public void setFormSqlProcessor(FormSqlProcessor formSqlProcessor) {
        this.formSqlProcessor = formSqlProcessor;
    }

    public FormInstance createFormInstance(String formDefineId){
		FormInstance formInstance=new FormInstance();
		FormModel formModel=FormModelFactory.getFormModel(formDefineId);
		PfFormDefineVo formDefineVo=formModel.getFormDefineVo();
		//formDefineVo.setDefinitionXlst(FormModelFactory.getFormModel(formDefineId));
		PfBusinessVo businessVo=formService.getBusiness(formDefineVo);
		formInstance.setFormDefineVo(formDefineVo);
		formInstance.setBusinessVo(businessVo);
		////
		try {
			Document formDefineDoc=formModel.getDefinitionXml();
			formInstance.setFormDefineDoc(formDefineDoc);
			formInstance.buildFormElementMap(formDefineDoc);
		} catch (Exception e) {
			log.error("表单定义错误，请检查！"+formDefineId,e);
		}
		return formInstance;
	}
    @SuppressWarnings("unchecked")
	public boolean saveFormInstance(Map requestMap,String formDefineId,String proId,HashMap queryParam) throws Exception{
		FormInstance formInstance=createFormInstance(formDefineId);
		formInstance.setQueryParam(queryParam);
		formInstance.setProId(proId);
		Map selectMap=checkResult(formInstance);
		if (selectMap==null){
			//需要insert
			insertFormInstance(formInstance);
            selectMap=checkResult(formInstance);
		}

		DataSource ds = BusinessDataSource.getDataSourceByBusiness(formInstance.getBusinessVo());

		String updateSql = formInstance.getFormDefineVo().getUpdateCommand();
		List<String>  updateSqlCommandList = FormSqlBuilder.buildUpdateSql(formInstance,requestMap,selectMap);
		Connection conn = null;
		Statement st = null;
		try {
			conn = ds.getConnection();
			st = conn.createStatement();
			
			for(int i=0;i<updateSqlCommandList.size();i++){
                try {
                    log.info("开始更新数据库：" +updateSqlCommandList.get(i));
				    st.executeUpdate(updateSqlCommandList.get(i));
                } catch (Exception e) {
                    throw e;
                }
			}
			saveGridForm(requestMap,formInstance,conn);
		} catch (Exception e) {
			log.error("表单更新SQL定义错误"
					+ formInstance.getFormDefineVo().getFormDefinitionId()
					+ "，请检查！" + updateSql, e);
			throw e;
		} finally {
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(conn);
		}
		return true;
	}
	@SuppressWarnings("unchecked")
	public boolean saveFormInstance(Map requestMap,String formDefineId,String proId) throws Exception{
		return saveFormInstance(requestMap,formDefineId,proId,null);
	}

    /**
     * 保存子表
     * @param requestMap
     * @param formInstance
     * @param conn
     * @return
     * @throws SQLException
     */
	public boolean  saveGridForm(Map requestMap,FormInstance formInstance,Connection conn) throws Exception{
		Document dDoc = formInstance.getFormDefineDoc();
		
		String fkValue="";//grid所在表的主键
		
		
		List defGroupElementList = dDoc
				.selectNodes("/DataSet/Define/GroupDefine");
		for (int i = 0; i < defGroupElementList.size(); i++) {
			Element elementGroup = (Element) defGroupElementList.get(i);
			String groupId = elementGroup.valueOf("@Id");
			GroupDefine groupDefine = new GroupDefine(requestMap, elementGroup);
			
			if (fkValue.length() == 0){
				//主要是获取grid所在表的主键
				fkValue = getFormTablePKValue(formInstance,groupDefine.getFkField(),conn);
			}
						
			
			groupDefine.updateGridForm(fkValue, conn);
		}
		return true;
	
	}

	/**
	 * 根据动态表单主表的查询语句，获取动态表单的主键值
	 * @param formInstance
	 * @param pkFieldName
	 * @param conn
	 * @return
	 * @throws SQLException
	 */
	public static String getFormTablePKValue(FormInstance formInstance,String pkFieldName,Connection conn) throws Exception{
		String fkValue="";
		String selectSql = formInstance.getFormDefineVo().getSelectCommand();
//		selectSql = FormSqlBuilder.replaceProIdSql(selectSql, formInstance
//				.getProId());
        FormSqlProcessor formSqlProcessor = (FormSqlProcessor) Container
                .getBean("FormSqlProcessor");
        selectSql=formSqlProcessor.processor(selectSql,formInstance.getProId(),formInstance.getQueryParam());
		//selectSql = selectSql.toLowerCase();
		if (selectSql.toLowerCase().lastIndexOf("from") < 0 ){
			return fkValue;
		}

		String fromStr = selectSql.substring(selectSql.toLowerCase().lastIndexOf("from"),selectSql.length());
		StringBuffer selectBuf = new StringBuffer();
		selectBuf.append("select ");
		Statement stmt =  conn.createStatement();
		selectBuf.append(pkFieldName);
		selectBuf.append(" ");
		selectBuf.append(fromStr);
		ResultSet rs = stmt.executeQuery(selectBuf.toString());
		if (rs.next()){
			fkValue = rs.getString(pkFieldName);
		}
		return fkValue;
	}
	

	
	/**
	 * 插入记录
	 * @param formInstance
	 */
	private void insertFormInstance(FormInstance formInstance) throws Exception{
		DataSource ds = BusinessDataSource.getDataSourceByBusiness(formInstance
				.getBusinessVo());
		String insertSql = formInstance.getFormDefineVo().getInsertCommand();
//		insertSql = FormSqlBuilder.replaceProIdSql(insertSql, formInstance
//				.getProId());
        insertSql=formSqlProcessor.processor(insertSql,formInstance.getProId(),formInstance.getQueryParam());
		insertSql = insertSql.replaceAll("\n", " ");
		insertSql = insertSql.replaceAll("\r", " ");
		List<String> insertSqlList = new Vector<String>();
		String sqlWorkStr = insertSql;
		while(sqlWorkStr.indexOf(StaticParamHelper.SQL_SEPARATOR)>=0){
			String childInsertSql = sqlWorkStr.substring(0,sqlWorkStr.indexOf(StaticParamHelper.SQL_SEPARATOR));
			insertSqlList.add(childInsertSql);
			sqlWorkStr = sqlWorkStr.substring(sqlWorkStr.indexOf(StaticParamHelper.SQL_SEPARATOR)+StaticParamHelper.SQL_SEPARATOR.length(), sqlWorkStr.length());
		}
		insertSqlList.add(sqlWorkStr);
		
		Connection conn = null;
		Statement st = null;
		try {
			conn = ds.getConnection();
			st = conn.createStatement();
			
			for (int i=0;i < insertSqlList.size();i++){
				String tempInsertSql = insertSqlList.get(i);
				if (tempInsertSql== null || tempInsertSql.trim().length()==0){
					continue;
				}
				
				if (tempInsertSql.indexOf(StaticParamHelper.SYS_BUILD_PK_AUTO) >0){
					String newPkId = UUIDGenerator.generate();
					tempInsertSql = tempInsertSql.replaceAll(StaticParamHelper.SYS_BUILD_PK_AUTO, "'"+newPkId+"'");
				}
				st.executeUpdate(tempInsertSql);
			}
		} catch (Exception e) {
			log.error("表单查询SQL定义错误"
					+ formInstance.getFormDefineVo().getFormDefinitionId()
					+ "，请检查！" + insertSql, e);
			throw e;
		} finally {
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(conn);
		}
	}
	
	

	
	private Map checkResult(FormInstance formInstance){
		DataSource ds = BusinessDataSource.getDataSourceByBusiness(formInstance
				.getBusinessVo());
		String selectSql = formInstance.getFormDefineVo().getSelectCommand();
//		selectSql = FormSqlBuilder.replaceProIdSql(selectSql, formInstance
//				.getProId());
//		Connection conn = null;
//		ResultSet rs = null;
//		Statement st = null;
		try {
            selectSql=formSqlProcessor.processor(selectSql,formInstance.getProId(),formInstance.getQueryParam());

            JdbcTemplate jdbcTemplate=new JdbcTemplate(ds);
            //Map result=jdbcTemplate.queryForMap(selectSql);
            List result=jdbcTemplate.queryForList(selectSql);
            if (result.size()>0)
                return (Map)result.get(0);
//			conn = ds.getConnection();
//			st = conn.createStatement();
//			rs = st.executeQuery(selectSql);
//			if (rs.next()) {
//				return true;
//			}
		} catch (Exception e) {
			log.error("表单查询SQL定义错误"
					+ formInstance.getFormDefineVo().getFormDefinitionId()
					+ "，请检查！" + selectSql, e);
		}
//        finally {
//			DataSourceManager.attemptClose(rs);
//			DataSourceManager.attemptClose(st);
//			DataSourceManager.attemptClose(conn);
//		}
		return null;
	}
	
	public SysFormService getFormService() {
		return formService;
	}
	public void setFormService(SysFormService formService) {
		this.formService = formService;
	}
	
}
