package com.gtis.plat.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfFormDefineVo;

/**
 * 表单实例
 * @author jiff
 *
 */
public class FormInstance {
	
	PfFormDefineVo formDefineVo;
	Document formDefineDoc;
	PfBusinessVo businessVo;
	Document formIntanceDoc;
	Map<String,FormElement> elementMap=new HashMap<String,FormElement>();
	
	String proId;
	HashMap queryParam;
	public String getProId() {
		return proId;
	}
	public void setProId(String proId) {
		this.proId = proId;
	}
	public Document getFormIntanceDoc() {
		return formIntanceDoc;
	}
	public void setFormIntanceDoc(Document formIntanceDoc) {
		this.formIntanceDoc = formIntanceDoc;
	}
	public PfFormDefineVo getFormDefineVo() {
		return formDefineVo;
	}
	public void setFormDefineVo(PfFormDefineVo formDefineVo) {
		this.formDefineVo = formDefineVo;
		
	}
	
	public void buildFormElementMap (Document defineDoc) throws DocumentException{
		if (defineDoc == null){
			return;
		}
		List<Node> lstNodes=(List<Node>)defineDoc.selectNodes("/DataSet/Define/ElementDefine");
		for(Node eleNode:lstNodes){
			FormElement formElement = new FormElement((Element)eleNode);
			this.elementMap.put(formElement.getElementId(),formElement);
		}
	}
	
	public Document getFormDefineDoc() {
		return formDefineDoc;
	}
	public void setFormDefineDoc(Document formDefineDoc) {
		this.formDefineDoc = formDefineDoc;
	}
	public PfBusinessVo getBusinessVo() {
		return businessVo;
	}
	public void setBusinessVo(PfBusinessVo businessVo) {
		this.businessVo = businessVo;
	}
	public Map<String, FormElement> getElementMap() {
		return elementMap;
	}
	public HashMap getQueryParam() {
		return queryParam;
	}
	public void setQueryParam(HashMap queryParam) {
		this.queryParam = queryParam;
	}
	
}
