package com.gtis.plat.dao;

import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SysWorkFlowInstanceExtDao extends SqlMapClientDaoSupport {
	private static final Log log = LogFactory.getLog(SysWorkFlowInstanceExtDao.class);

    public List<PfWorkFlowInstanceVo> getWorkFlowsInstanceByDefine(HashMap paraMap){
		if (paraMap != null && paraMap.keySet().size() > 0){
			return (List<PfWorkFlowInstanceVo>)super.getSqlMapClientTemplate().queryForList("getWorkFlowInstanceList",paraMap);
		}
		return null;
    }

	public Object getObjectByIbatis(HashMap paraMap,String ibatis){
		if (paraMap != null && paraMap.keySet().size() > 0 && StringUtils.isNotBlank(ibatis)){
			return super.getSqlMapClientTemplate().queryForObject(ibatis, paraMap);
		}
		return null;
	}

	public HashMap getMapByIbatis(HashMap paraMap,String ibatis){
		if (paraMap != null && paraMap.keySet().size() > 0 && StringUtils.isNotBlank(ibatis)){
			return (HashMap)super.getSqlMapClientTemplate().queryForObject(ibatis, paraMap);
		}
		return null;
	}

	public List getListByIbatis(HashMap paraMap,String ibatis){
		if (paraMap != null && paraMap.keySet().size() > 0 && StringUtils.isNotBlank(ibatis)){
			return super.getSqlMapClientTemplate().queryForList(ibatis, paraMap);
		}
		return null;
	}
}
